/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.support;

import ext.jtester.org.apache.commons.dbutils.DbUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.jtester.exception.JTesterException;
import org.jtester.module.database.support.SQLHandler;
import org.jtester.utility.JTesterLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSQLHandler
implements SQLHandler {
    private DataSource dataSource;
    private boolean doExecuteUpdates;

    public DefaultSQLHandler(DataSource dataSource) {
        this(dataSource, true);
    }

    public DefaultSQLHandler(DataSource dataSource, boolean doExecuteUpdates) {
        this.dataSource = dataSource;
        this.doExecuteUpdates = doExecuteUpdates;
    }

    @Override
    public int executeUpdate(String sql) {
        int n;
        JTesterLogger.debug(sql);
        if (!this.doExecuteUpdates) {
            return 0;
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            n = statement.executeUpdate(sql);
        }
        catch (Throwable e) {
            try {
                throw new JTesterException("Error while performing database update: " + sql, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, statement, null);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, statement, null);
        return n;
    }

    @Override
    public void executeQuery(String sql) {
        JTesterLogger.debug(sql);
        if (!this.doExecuteUpdates) {
            return;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
        }
        catch (Throwable e) {
            try {
                throw new JTesterException("Error while performing database update: " + sql, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, statement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
    }

    @Override
    public int executeUpdateAndCommit(String sql) {
        int n;
        JTesterLogger.debug(sql);
        if (!this.doExecuteUpdates) {
            return 0;
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            int nbChanges = statement.executeUpdate(sql);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            n = nbChanges;
        }
        catch (Throwable e) {
            try {
                throw new JTesterException("Error while performing database update: " + sql, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, statement, null);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, statement, null);
        return n;
    }

    @Override
    public long getItemAsLong(String sql) {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block4: {
            long l;
            JTesterLogger.debug(sql);
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = this.dataSource.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(sql);
                if (!resultSet.next()) break block4;
                l = resultSet.getLong(1);
            }
            catch (Throwable e) {
                try {
                    throw new JTesterException("Error while executing statement: " + sql, e);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(connection, statement, resultSet);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly(connection, statement, resultSet);
            return l;
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
        throw new JTesterException("No item value found: " + sql);
    }

    @Override
    public String getItemAsString(String sql) {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block4: {
            String string;
            JTesterLogger.debug(sql);
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = this.dataSource.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(sql);
                if (!resultSet.next()) break block4;
                string = resultSet.getString(1);
            }
            catch (Throwable e) {
                try {
                    throw new JTesterException("Error while executing statement: " + sql, e);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(connection, statement, resultSet);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly(connection, statement, resultSet);
            return string;
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
        throw new JTesterException("No item value found: " + sql);
    }

    @Override
    public Set<String> getItemsAsStringSet(String sql) {
        HashSet<String> hashSet;
        JTesterLogger.debug(sql);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            HashSet<String> result = new HashSet<String>();
            while (resultSet.next()) {
                result.add(resultSet.getString(1));
            }
            hashSet = result;
        }
        catch (Throwable e) {
            try {
                throw new JTesterException("Error while executing statement: " + sql, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, statement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
        return hashSet;
    }

    @Override
    public boolean exists(String sql) {
        boolean bl;
        JTesterLogger.debug(sql);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            bl = resultSet.next();
        }
        catch (Throwable e) {
            try {
                throw new JTesterException("Error while executing statement: " + sql, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, statement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
        return bl;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public boolean isDoExecuteUpdates() {
        return this.doExecuteUpdates;
    }
}

