/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.support;

import java.util.Set;
import org.jtester.module.database.support.DbSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H2DbSupport
extends DbSupport {
    public H2DbSupport() {
        super("h2db");
    }

    @Override
    public Set<String> getColumnNames(String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = '" + tableName + "' AND TABLE_SCHEMA = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getTableNames() {
        return this.getSQLHandler().getItemsAsStringSet("select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_TYPE = 'TABLE' AND TABLE_SCHEMA = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getViewNames() {
        return this.getSQLHandler().getItemsAsStringSet("select TABLE_NAME from INFORMATION_SCHEMA.SYSTEM_TABLES where TABLE_TYPE = 'VIEW' AND TABLE_SCHEMA = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getSequenceNames() {
        return this.getSQLHandler().getItemsAsStringSet("select SEQUENCE_NAME from INFORMATION_SCHEMA.SYSTEM_SEQUENCES where SEQUENCE_SCHEMA = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getTriggerNames() {
        return this.getSQLHandler().getItemsAsStringSet("select TRIGGER_NAME from INFORMATION_SCHEMA.SYSTEM_TRIGGERS where TRIGGER_SCHEM = '" + this.getSchemaName() + "'");
    }

    @Override
    public long getSequenceValue(String sequenceName) {
        return this.getSQLHandler().getItemAsLong("select START_WITH from INFORMATION_SCHEMA.SYSTEM_SEQUENCES where SEQUENCE_SCHEMA = '" + this.getSchemaName() + "' and SEQUENCE_NAME = '" + sequenceName + "'");
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsIdentityColumns() {
        return true;
    }

    @Override
    public void incrementSequenceToValue(String sequenceName, long newSequenceValue) {
        this.getSQLHandler().executeUpdate("alter sequence " + this.qualified(sequenceName) + " restart with " + newSequenceValue);
    }

    @Override
    public void incrementIdentityColumnToValue(String tableName, String identityColumnName, long identityValue) {
        this.getSQLHandler().executeUpdate("alter table " + this.qualified(tableName) + " alter column " + this.quoted(identityColumnName) + " RESTART WITH " + identityValue);
    }

    @Override
    public void disableReferentialConstraints() {
        Set<String> tableNames = this.getTableNames();
        for (String tableName : tableNames) {
            this.disableReferentialConstraints(tableName);
        }
    }

    @Override
    public void disableValueConstraints() {
        Set<String> tableNames = this.getTableNames();
        for (String tableName : tableNames) {
            this.disableValueConstraints(tableName);
        }
    }

    private void disableReferentialConstraints(String tableName) {
        Set<String> constraintNames = this.getForeignKeyConstraintNames(tableName);
        for (String constraintName : constraintNames) {
            this.removeForeignKeyConstraint(tableName, constraintName);
        }
    }

    private void disableValueConstraints(String tableName) {
        Set<String> primaryKeyColumnNames = this.getPrimaryKeyColumnNames(tableName);
        Set<String> notNullColumnNames = this.getNotNullColummnNames(tableName);
        for (String notNullColumnName : notNullColumnNames) {
            if (primaryKeyColumnNames.contains(notNullColumnName)) continue;
            this.removeNotNullConstraint(tableName, notNullColumnName);
        }
    }

    private Set<String> getPrimaryKeyColumnNames(String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select COLUMN_NAME from INFORMATION_SCHEMA.INDEXES where PRIMARY_KEY=TRUE AND TABLE_NAME = '" + tableName + "' AND TABLE_SCHEMA = '" + this.getSchemaName() + "'");
    }

    private Set<String> getNotNullColummnNames(String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS where IS_NULLABLE = 'NO' AND TABLE_NAME = '" + tableName + "' AND TABLE_SCHEMA = '" + this.getSchemaName() + "'");
    }

    private Set<String> getForeignKeyConstraintNames(String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select CONSTRAINT_NAME from INFORMATION_SCHEMA.CONSTRAINTS where CONSTRAINT_TYPE = 'REFERENTIAL' AND TABLE_NAME = '" + tableName + "' AND CONSTRAINT_SCHEMA = '" + this.getSchemaName() + "'");
    }

    private void removeForeignKeyConstraint(String tableName, String constraintName) {
        this.getSQLHandler().executeUpdate("alter table " + this.qualified(tableName) + " drop constraint " + this.quoted(constraintName));
    }

    private void removeNotNullConstraint(String tableName, String columnName) {
        this.getSQLHandler().executeUpdate("alter table " + this.qualified(tableName) + " alter column " + this.quoted(columnName) + " set null");
    }
}

