/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.support;

import ext.jtester.org.apache.commons.dbutils.DbUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Set;
import org.jtester.exception.JTesterException;
import org.jtester.module.database.support.DbSupport;
import org.jtester.module.database.support.SQLHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HsqldbDbSupport
extends DbSupport {
    public HsqldbDbSupport() {
        super("hsqldb");
    }

    @Override
    public Set<String> getTableNames() {
        SQLHandler handler = this.getSQLHandler();
        Set<String> set = handler.getItemsAsStringSet("select TABLE_NAME from INFORMATION_SCHEMA.SYSTEM_TABLES where TABLE_TYPE = 'TABLE' AND TABLE_SCHEM = '" + this.getSchemaName() + "'");
        return set;
    }

    @Override
    public Set<String> getColumnNames(String tableName) {
        SQLHandler handler = this.getSQLHandler();
        Set<String> set = handler.getItemsAsStringSet("select COLUMN_NAME from INFORMATION_SCHEMA.SYSTEM_COLUMNS where TABLE_NAME = '" + tableName + "' AND TABLE_SCHEM = '" + this.getSchemaName() + "'");
        return set;
    }

    @Override
    public Set<String> getViewNames() {
        SQLHandler handler = this.getSQLHandler();
        Set<String> set = handler.getItemsAsStringSet("select TABLE_NAME from INFORMATION_SCHEMA.SYSTEM_TABLES where TABLE_TYPE = 'VIEW' AND TABLE_SCHEM = '" + this.getSchemaName() + "'");
        return set;
    }

    @Override
    public Set<String> getSequenceNames() {
        SQLHandler handler = this.getSQLHandler();
        Set<String> set = handler.getItemsAsStringSet("select SEQUENCE_NAME from INFORMATION_SCHEMA.SYSTEM_SEQUENCES where SEQUENCE_SCHEMA = '" + this.getSchemaName() + "'");
        return set;
    }

    @Override
    public Set<String> getTriggerNames() {
        SQLHandler handler = this.getSQLHandler();
        Set<String> set = handler.getItemsAsStringSet("select TRIGGER_NAME from INFORMATION_SCHEMA.SYSTEM_TRIGGERS where TRIGGER_SCHEM = '" + this.getSchemaName() + "'");
        return set;
    }

    @Override
    public void disableReferentialConstraints() {
        Connection connection = null;
        Statement queryStatement = null;
        Statement alterStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getSQLHandler().getDataSource().getConnection();
            queryStatement = connection.createStatement();
            alterStatement = connection.createStatement();
            resultSet = queryStatement.executeQuery("select TABLE_NAME, CONSTRAINT_NAME from INFORMATION_SCHEMA.SYSTEM_TABLE_CONSTRAINTS where CONSTRAINT_TYPE = 'FOREIGN KEY' AND CONSTRAINT_SCHEMA = '" + this.getSchemaName() + "'");
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                String constraintName = resultSet.getString("CONSTRAINT_NAME");
                alterStatement.executeUpdate("alter table " + this.qualified(tableName) + " drop constraint " + this.quoted(constraintName));
            }
        }
        catch (Throwable e) {
            try {
                throw new JTesterException("Error while disabling not referential constraints on schema " + this.getSchemaName(), e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(queryStatement);
                DbUtils.closeQuietly(connection, alterStatement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(queryStatement);
        DbUtils.closeQuietly(connection, alterStatement, resultSet);
    }

    @Override
    public void disableValueConstraints() {
        this.disableCheckAndUniqueConstraints();
        this.disableNotNullConstraints();
    }

    protected void disableCheckAndUniqueConstraints() {
        Connection connection = null;
        Statement queryStatement = null;
        Statement alterStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getSQLHandler().getDataSource().getConnection();
            queryStatement = connection.createStatement();
            alterStatement = connection.createStatement();
            resultSet = queryStatement.executeQuery("select TABLE_NAME, CONSTRAINT_NAME from INFORMATION_SCHEMA.SYSTEM_TABLE_CONSTRAINTS where CONSTRAINT_TYPE IN ('CHECK', 'UNIQUE') AND CONSTRAINT_SCHEMA = '" + this.getSchemaName() + "'");
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                String constraintName = resultSet.getString("CONSTRAINT_NAME");
                alterStatement.executeUpdate("alter table " + this.qualified(tableName) + " drop constraint " + this.quoted(constraintName));
            }
        }
        catch (Throwable e) {
            try {
                throw new JTesterException("Error while disabling check and unique constraints on schema " + this.getSchemaName(), e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(queryStatement);
                DbUtils.closeQuietly(connection, alterStatement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(queryStatement);
        DbUtils.closeQuietly(connection, alterStatement, resultSet);
    }

    protected void disableNotNullConstraints() {
        Connection connection = null;
        Statement queryStatement = null;
        Statement alterStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getSQLHandler().getDataSource().getConnection();
            queryStatement = connection.createStatement();
            alterStatement = connection.createStatement();
            resultSet = queryStatement.executeQuery("select col.TABLE_NAME, col.COLUMN_NAME from INFORMATION_SCHEMA.SYSTEM_COLUMNS col where col.IS_NULLABLE = 'NO' and col.TABLE_SCHEM = '" + this.getSchemaName() + "' " + "AND NOT EXISTS ( select COLUMN_NAME from INFORMATION_SCHEMA.SYSTEM_PRIMARYKEYS pk where pk.TABLE_NAME = col.TABLE_NAME and pk.COLUMN_NAME = col.COLUMN_NAME and pk.TABLE_SCHEM = '" + this.getSchemaName() + "' )");
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                String columnName = resultSet.getString("COLUMN_NAME");
                alterStatement.executeUpdate("alter table " + this.qualified(tableName) + " alter column " + this.quoted(columnName) + " set null");
            }
        }
        catch (Throwable e) {
            try {
                throw new JTesterException("Error while disabling not null constraints on schema " + this.getSchemaName(), e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(queryStatement);
                DbUtils.closeQuietly(connection, alterStatement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(queryStatement);
        DbUtils.closeQuietly(connection, alterStatement, resultSet);
    }

    @Override
    public long getSequenceValue(String sequenceName) {
        SQLHandler handler = this.getSQLHandler();
        long item = handler.getItemAsLong("select START_WITH from INFORMATION_SCHEMA.SYSTEM_SEQUENCES where SEQUENCE_SCHEMA = '" + this.getSchemaName() + "' and SEQUENCE_NAME = '" + sequenceName + "'");
        return item;
    }

    @Override
    public void incrementSequenceToValue(String sequenceName, long newSequenceValue) {
        SQLHandler handler = this.getSQLHandler();
        handler.executeUpdate("alter sequence " + this.qualified(sequenceName) + " restart with " + newSequenceValue);
    }

    @Override
    public Set<String> getIdentityColumnNames(String tableName) {
        SQLHandler handler = this.getSQLHandler();
        Set<String> set = handler.getItemsAsStringSet("select COLUMN_NAME from INFORMATION_SCHEMA.SYSTEM_PRIMARYKEYS where TABLE_NAME = '" + tableName + "' AND TABLE_SCHEM = '" + this.getSchemaName() + "'");
        return set;
    }

    @Override
    public void incrementIdentityColumnToValue(String tableName, String identityColumnName, long identityValue) {
        SQLHandler handler = this.getSQLHandler();
        handler.executeUpdate("alter table " + this.qualified(tableName) + " alter column " + this.quoted(identityColumnName) + " RESTART WITH " + identityValue);
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsIdentityColumns() {
        return true;
    }

    @Override
    public boolean supportsCascade() {
        return true;
    }
}

