/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.support;

import ext.jtester.org.apache.commons.dbutils.DbUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Set;
import org.jtester.exception.JTesterException;
import org.jtester.module.database.support.DbSupport;
import org.jtester.module.database.support.SQLHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsSqlDbSupport
extends DbSupport {
    public MsSqlDbSupport() {
        super("mssql");
    }

    @Override
    public Set<String> getTableNames() {
        SQLHandler handler = this.getSQLHandler();
        Set<String> set = handler.getItemsAsStringSet("select t.name from sys.tables t, sys.schemas s where t.schema_id = s.schema_id and s.name = '" + this.getSchemaName() + "'");
        return set;
    }

    @Override
    public Set<String> getColumnNames(String tableName) {
        SQLHandler handler = this.getSQLHandler();
        Set<String> set = handler.getItemsAsStringSet("select c.name from sys.columns c, sys.tables t, sys.schemas s where c.object_id = t.object_id and t.name = '" + tableName + "' and t.schema_id = s.schema_id and s.name = '" + this.getSchemaName() + "'");
        return set;
    }

    @Override
    public Set<String> getViewNames() {
        SQLHandler handler = this.getSQLHandler();
        Set<String> set = handler.getItemsAsStringSet("select v.name from sys.views v, sys.schemas s where v.schema_id = s.schema_id and s.name = '" + this.getSchemaName() + "'");
        return set;
    }

    @Override
    public Set<String> getSynonymNames() {
        SQLHandler handler = this.getSQLHandler();
        Set<String> set = handler.getItemsAsStringSet("select o.name from sys.synonyms o, sys.schemas s where o.schema_id = s.schema_id and s.name = '" + this.getSchemaName() + "'");
        return set;
    }

    @Override
    public Set<String> getTriggerNames() {
        SQLHandler handler = this.getSQLHandler();
        Set<String> set = handler.getItemsAsStringSet("select t.name from sys.triggers t, sys.all_objects o, sys.schemas s where t.parent_id = o.object_id and o.schema_id = s.schema_id and s.name = '" + this.getSchemaName() + "'");
        return set;
    }

    @Override
    public Set<String> getTypeNames() {
        SQLHandler handler = this.getSQLHandler();
        Set<String> set = handler.getItemsAsStringSet("select t.name from sys.types t, sys.schemas s where t.schema_id = s.schema_id and s.name = '" + this.getSchemaName() + "'");
        return set;
    }

    @Override
    public Set<String> getIdentityColumnNames(String tableName) {
        SQLHandler handler = this.getSQLHandler();
        Set<String> set = handler.getItemsAsStringSet("select i.name from sys.identity_columns i, sys.tables t, sys.schemas s where i.object_id = t.object_id and t.name = '" + tableName + "' and t.schema_id = s.schema_id and s.name = '" + this.getSchemaName() + "'");
        return set;
    }

    @Override
    public void disableReferentialConstraints() {
        Set<String> tableNames = this.getTableNames();
        for (String tableName : tableNames) {
            this.disableReferentialConstraints(tableName);
        }
    }

    protected void disableReferentialConstraints(String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> constraintNames = sqlHandler.getItemsAsStringSet("select f.name from sys.foreign_keys f, sys.tables t, sys.schemas s where f.parent_object_id = t.object_id and t.name = '" + tableName + "' and t.schema_id = s.schema_id and s.name = '" + this.getSchemaName() + "'");
        for (String constraintName : constraintNames) {
            sqlHandler.executeUpdate("alter table " + this.qualified(tableName) + " drop constraint " + this.quoted(constraintName));
        }
    }

    @Override
    public void disableValueConstraints() {
        Set<String> tableNames = this.getTableNames();
        for (String tableName : tableNames) {
            this.disableValueConstraints(tableName);
        }
    }

    protected void disableValueConstraints(String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> keyConstraintNames = sqlHandler.getItemsAsStringSet("select k.name from sys.key_constraints k, sys.tables t, sys.schemas s where k.type = 'UQ' and k.parent_object_id = t.object_id and t.name = '" + tableName + "' and t.schema_id = s.schema_id and s.name = '" + this.getSchemaName() + "'");
        for (String keyConstraintName : keyConstraintNames) {
            sqlHandler.executeUpdate("alter table " + this.qualified(tableName) + " drop constraint " + this.quoted(keyConstraintName));
        }
        Set<String> checkConstraintNames = sqlHandler.getItemsAsStringSet("select c.name from sys.check_constraints c, sys.tables t, sys.schemas s where c.parent_object_id = t.object_id and t.name = '" + tableName + "' and t.schema_id = s.schema_id and s.name = '" + this.getSchemaName() + "'");
        for (String checkConstraintName : checkConstraintNames) {
            sqlHandler.executeUpdate("alter table " + this.qualified(tableName) + " drop constraint " + this.quoted(checkConstraintName));
        }
        this.disableNotNullConstraints(tableName);
    }

    @Override
    public void incrementIdentityColumnToValue(String tableName, String identityColumnName, long identityValue) {
        this.getSQLHandler().executeUpdate("DBCC CHECKIDENT ('" + this.qualified(tableName) + "', reseed, " + identityValue + ")");
    }

    @Override
    public boolean supportsSynonyms() {
        return true;
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsTypes() {
        return true;
    }

    @Override
    public boolean supportsIdentityColumns() {
        return true;
    }

    protected void disableNotNullConstraints(String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> primaryKeyColumnNames = sqlHandler.getItemsAsStringSet("select c.name from sys.key_constraints k, sys.index_columns i, sys.columns c, sys.tables t, sys.schemas s where k.type = 'PK' and i.index_id = k.unique_index_id and i.column_id = c.column_id   and c.object_id = t.object_id and k.parent_object_id = t.object_id and i.object_id = t.object_id   and t.name = '" + tableName + "' and t.schema_id = s.schema_id and s.name = '" + this.getSchemaName() + "'");
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = sqlHandler.getDataSource().getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select c.name column_name, upper(y.name) data_type, c.max_length, c.precision from sys.types y, sys.columns c, sys.tables t, sys.schemas s where c.is_nullable = 0 and c.is_rowguidcol = 0 and c.is_identity = 0 and c.is_computed = 0   and y.user_type_id = c.user_type_id and c.object_id = t.object_id and t.name = '" + tableName + "' and t.schema_id = s.schema_id and s.name = '" + this.getSchemaName() + "'");
            while (resultSet.next()) {
                String maxLength;
                String dataType;
                String columnName = resultSet.getString("column_name");
                if (primaryKeyColumnNames.contains(columnName) || "TIMESTAMP".equals(dataType = resultSet.getString("data_type"))) continue;
                if ("NUMERIC".equals(dataType) || "DECIMAL".equals(dataType)) {
                    maxLength = resultSet.getString("max_length");
                    String precision = resultSet.getString("precision");
                    dataType = dataType + "(" + maxLength + ", " + precision + ")";
                } else if (dataType.contains("CHAR")) {
                    maxLength = resultSet.getString("max_length");
                    dataType = dataType + "(" + maxLength + ")";
                }
                sqlHandler.executeUpdate("alter table " + this.qualified(tableName) + " alter column " + this.quoted(columnName) + " " + dataType + " null");
            }
        }
        catch (Throwable e) {
            try {
                throw new JTesterException("Error while disabling not null constraints. Table name: " + tableName, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, statement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
    }
}

