/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.util;

import java.util.List;
import java.util.Properties;
import org.jtester.module.core.helper.ConfigurationHelper;
import org.jtester.module.database.support.DbSupport;
import org.jtester.module.database.support.DbSupportFactory;
import org.jtester.module.database.support.SQLHandler;
import org.jtester.module.database.util.DatabaseAccessing;

public abstract class BaseDatabaseAccessor
implements DatabaseAccessing {
    protected Properties configuration;
    protected SQLHandler sqlHandler;
    protected DbSupport defaultDbSupport;
    protected List<DbSupport> dbSupports;

    public void init(SQLHandler sqlHandler) {
        this.configuration = ConfigurationHelper.getConfiguration();
        this.sqlHandler = sqlHandler;
        this.dbSupports = DbSupportFactory.getDbSupports(this.configuration, sqlHandler);
        this.defaultDbSupport = DbSupportFactory.getDefaultDbSupport(this.configuration, sqlHandler);
        this.doInit(this.configuration);
    }

    protected void doInit(Properties configuration) {
    }

    public DbSupport getDbSupport(String schemaName) {
        return DbSupportFactory.getDbSupport(this.configuration, this.sqlHandler, schemaName);
    }
}

