/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jtester.bytecode.reflector.FieldAccessor;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.core.IJTester;
import org.jtester.exception.NoSuchFieldRuntimeException;
import org.jtester.module.database.util.StamentStatus;
import org.jtester.module.dbfit.db.model.DbParameterAccessor;
import org.jtester.utility.JTesterLogger;
import org.jtester.utility.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBHelper {
    public static void closeStatement(Statement st) {
        if (st == null) {
            return;
        }
        try {
            st.close();
            st = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
            rs = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Map getMapFromResult(ResultSet rs, ResultSetMetaData rsmd, boolean isCamelName) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int count = rsmd.getColumnCount();
        for (int index = 1; index <= count; ++index) {
            String key = DBHelper.getCamelFieldName(rsmd, index, isCamelName);
            Object o = rs.getObject(index);
            Object value = DbParameterAccessor.normaliseValue(o);
            map.put(key, value);
        }
        return map;
    }

    public static List<Map> getListMapFromResult(ResultSet rs, ResultSetMetaData rsmd, boolean isCamelName) throws Exception {
        ArrayList<Map> list = new ArrayList<Map>();
        while (rs.next()) {
            Map map = DBHelper.getMapFromResult(rs, rsmd, isCamelName);
            list.add(map);
        }
        return list;
    }

    public static <T> T getPoJoFromResult(ResultSet rs, ResultSetMetaData rsmd, Class<T> clazz) throws Exception {
        int count = rsmd.getColumnCount();
        if (count == 1) {
            Object o = rs.getObject(1);
            Object value = DbParameterAccessor.normaliseValue(o);
            return (T)value;
        }
        T pojo = ClazzHelper.newInstance(clazz);
        for (int index = 1; index <= count; ++index) {
            String key = DBHelper.getCamelFieldName(rsmd, index, true);
            try {
                FieldAccessor accessor = new FieldAccessor(clazz, key);
                Object o = rs.getObject(index);
                Object value = DbParameterAccessor.normaliseValue(o);
                accessor.set(pojo, value);
                continue;
            }
            catch (NoSuchFieldRuntimeException e) {
                JTesterLogger.warn("set pojo property errro: " + e.getMessage());
            }
        }
        return pojo;
    }

    public static <T> List<T> getListPoJoFromResult(ResultSet rs, ResultSetMetaData rsmd, Class<T> clazz) throws Exception {
        ArrayList<T> list = new ArrayList<T>();
        while (rs.next()) {
            T o = DBHelper.getPoJoFromResult(rs, rsmd, clazz);
            list.add(o);
        }
        return list;
    }

    private static String getCamelFieldName(ResultSetMetaData rsmd, int index, boolean isCamelName) throws SQLException {
        String columnName = rsmd.getColumnName(index);
        if (isCamelName) {
            columnName = columnName.replaceAll("[^a-zA-Z0-9]", " ");
            String fieldName = StringHelper.camel(columnName.toLowerCase());
            return fieldName;
        }
        return columnName;
    }

    public static void fillData(Map<String, Object> map, String table) {
    }

    public static String[] parseSQL(String content) {
        char[] chars = content.toCharArray();
        ArrayList<String> statements = new ArrayList<String>();
        StamentStatus status = StamentStatus.NORMAL;
        StringBuffer buff = new StringBuffer();
        block7: for (int index = 0; index < chars.length; ++index) {
            char ch = chars[index];
            int next = 0;
            switch (status) {
                case SINGLE_NOTE: {
                    if (ch != '\n' && ch != '\r') continue block7;
                    buff.append(' ');
                    status = StamentStatus.NORMAL;
                    continue block7;
                }
                case MULTI_NOTE: {
                    int n = next = index == chars.length - 1 ? 47 : chars[index + 1];
                    if (ch != '*' || next != 47) continue block7;
                    ++index;
                    status = StamentStatus.NORMAL;
                    continue block7;
                }
                case SINGLE_QUOTATION: {
                    buff.append(ch);
                    if (ch != '\'') continue block7;
                    status = StamentStatus.NORMAL;
                    continue block7;
                }
                case DOUBLE_QUOTATION: {
                    buff.append(ch);
                    if (ch != '\"') continue block7;
                    status = StamentStatus.NORMAL;
                    continue block7;
                }
                case NORMAL: {
                    int n = next = index == chars.length - 1 ? 59 : chars[index + 1];
                    if (ch == '-' && next == 45) {
                        ++index;
                        status = StamentStatus.SINGLE_NOTE;
                        continue block7;
                    }
                    if (ch == '/' && next == 42) {
                        ++index;
                        status = StamentStatus.MULTI_NOTE;
                        continue block7;
                    }
                    if (ch == '\'') {
                        buff.append(ch);
                        status = StamentStatus.SINGLE_QUOTATION;
                        continue block7;
                    }
                    if (ch == '\"') {
                        buff.append(ch);
                        status = StamentStatus.DOUBLE_QUOTATION;
                        continue block7;
                    }
                    if (ch == ';') {
                        String statement = buff.toString().trim();
                        if (!"".equals(statement)) {
                            statements.add(statement);
                        }
                        buff = new StringBuffer();
                        continue block7;
                    }
                    if (ch == '\n' || ch == '\r') {
                        buff.append(' ');
                        continue block7;
                    }
                    buff.append(ch);
                }
            }
        }
        String statement = buff.toString().trim();
        if (!"".equals(statement)) {
            statements.add(statement);
        }
        String[] stmts = new String[statements.size()];
        statements.toArray(stmts);
        return stmts;
    }

    public static String getWhereCondiction(IJTester.DataMap map) {
        if (map == null || map.size() == 0) {
            return "";
        }
        StringBuilder where = new StringBuilder();
        where.append(" where ");
        boolean isFirst = true;
        for (String key : map.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                where.append(" and ");
            }
            where.append(key).append("=?");
        }
        return where.toString();
    }
}

