/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.util;

import org.jtester.exception.UnConfigDataBaseTypeException;
import org.jtester.module.core.helper.ConfigurationHelper;
import org.jtester.module.database.support.Db2DbSupport;
import org.jtester.module.database.support.DbSupport;
import org.jtester.module.database.support.DerbyDbSupport;
import org.jtester.module.database.support.H2DbSupport;
import org.jtester.module.database.support.HsqldbDbSupport;
import org.jtester.module.database.support.MsSqlDbSupport;
import org.jtester.module.database.support.MySqlDbSupport;
import org.jtester.module.database.support.OracleDbSupport;
import org.jtester.utility.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataSourceType {
    H2DB{

        public DbSupport getDbSupport() {
            return new H2DbSupport();
        }

        public boolean autoExport() {
            return true;
        }

        public boolean isMemoryDB() {
            return true;
        }
    }
    ,
    HSQLDB{

        public DbSupport getDbSupport() {
            return new HsqldbDbSupport();
        }

        public boolean autoExport() {
            return true;
        }

        public boolean isMemoryDB() {
            return true;
        }
    }
    ,
    MYSQL{

        public DbSupport getDbSupport() {
            return new MySqlDbSupport();
        }
    }
    ,
    ORACLE{

        public DbSupport getDbSupport() {
            return new OracleDbSupport();
        }
    }
    ,
    SQLSERVER{

        public DbSupport getDbSupport() {
            return new MsSqlDbSupport();
        }
    }
    ,
    DERBYDB{

        public DbSupport getDbSupport() {
            return new DerbyDbSupport();
        }
    }
    ,
    DB2{

        public DbSupport getDbSupport() {
            return new Db2DbSupport();
        }
    }
    ,
    UNSUPPORT{

        public DbSupport getDbSupport() {
            throw new RuntimeException("unsupport database type");
        }
    };

    private String hibernate_dialect = null;
    private String infoSchema = null;

    public String getHibernateDialect() {
        return this.hibernate_dialect;
    }

    public abstract DbSupport getDbSupport();

    public String getInfoSchema() {
        return this.infoSchema;
    }

    public boolean isMemoryDB() {
        return false;
    }

    public boolean autoExport() {
        return ConfigurationHelper.autoExport();
    }

    public static DataSourceType databaseType(String type) {
        String _type = type;
        if (StringHelper.isBlankOrNull(type)) {
            _type = ConfigurationHelper.databaseType();
        }
        if (StringHelper.isBlankOrNull(_type)) {
            throw new UnConfigDataBaseTypeException("please config property 'database.type'");
        }
        try {
            DataSourceType dbType = DataSourceType.valueOf(_type.toUpperCase());
            return dbType;
        }
        catch (Throwable e) {
            throw new RuntimeException("unknown database type", e);
        }
    }
}

