/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.util;

import org.jtester.module.database.support.DbSupport;
import org.jtester.module.database.util.BaseDatabaseAccessor;
import org.jtester.module.database.util.ConstraintsDisabler;
import org.jtester.utility.JTesterLogger;

public class DefaultConstraintsDisabler
extends BaseDatabaseAccessor
implements ConstraintsDisabler {
    public void disableConstraints() {
        for (DbSupport dbSupport : this.dbSupports) {
            JTesterLogger.info("Disabling constraints in database schema " + dbSupport.getSchemaName());
            this.disableReferentialConstraints(dbSupport);
            this.disableValueConstraints(dbSupport);
        }
    }

    protected void disableReferentialConstraints(DbSupport dbSupport) {
        try {
            dbSupport.disableReferentialConstraints();
        }
        catch (Throwable t) {
            JTesterLogger.error("Unable to remove referential constraints.", t);
        }
    }

    protected void disableValueConstraints(DbSupport dbSupport) {
        try {
            dbSupport.disableValueConstraints();
        }
        catch (Throwable t) {
            JTesterLogger.error("Unable to remove value constraints.", t);
        }
    }
}

