/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.util;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.List;
import java.util.Map;
import org.jtester.core.IJTester;
import org.jtester.exception.DbFitException;
import org.jtester.exception.ExceptionWrapper;
import org.jtester.fit.util.SymbolUtil;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.environment.DBEnvironmentFactory;
import org.jtester.module.database.util.DBHelper;
import org.jtester.utility.ResourceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlRunner {
    public static void commit() {
        try {
            DBEnvironment environment = DBEnvironmentFactory.getCurrentDBEnvironment();
            environment.connectIfNeeded();
            environment.commit();
        }
        catch (Exception e) {
            throw ExceptionWrapper.getUndeclaredThrowableExceptionCaused(e);
        }
    }

    public static void rollback() {
        try {
            DBEnvironment environment = DBEnvironmentFactory.getCurrentDBEnvironment();
            environment.connectIfNeeded();
            environment.rollback();
        }
        catch (Exception e) {
            throw ExceptionWrapper.getUndeclaredThrowableExceptionCaused(e);
        }
    }

    public static void execute(String sql) {
        DBEnvironment environment = DBEnvironmentFactory.getCurrentDBEnvironment();
        environment.connectIfNeeded();
        PreparedStatement st = null;
        try {
            st = environment.createStatementWithBoundFixtureSymbols(sql);
            st.execute();
        }
        catch (Throwable e) {
            throw ExceptionWrapper.getUndeclaredThrowableExceptionCaused(e);
        }
        finally {
            DBHelper.closeStatement(st);
        }
    }

    public static void executeFromFile(Map<String, ?> symbols, String fileName) throws Exception {
        SymbolUtil.setSymbol(symbols);
        SqlRunner.executeFromFile(fileName);
    }

    public static void executeFromFile(String fileName) throws Exception {
        String[] statements;
        DBEnvironment environment = DBEnvironmentFactory.getCurrentDBEnvironment();
        environment.connectIfNeeded();
        String sqls = ResourceHelper.readFromFile(fileName);
        for (String statment : statements = DBHelper.parseSQL(sqls)) {
            PreparedStatement st = null;
            try {
                st = environment.createStatementWithBoundFixtureSymbols(statment);
                st.execute();
            }
            catch (Throwable e) {
                throw new DbFitException("there are some error when execute sql file [" + fileName + "]", e);
            }
            finally {
                DBHelper.closeStatement(st);
            }
        }
    }

    public static void executeFromStream(InputStream is) throws Exception {
        String[] statements;
        DBEnvironment environment = DBEnvironmentFactory.getCurrentDBEnvironment();
        environment.connectIfNeeded();
        String sqls = ResourceHelper.readFromStream(is);
        for (String statment : statements = DBHelper.parseSQL(sqls)) {
            PreparedStatement st = null;
            try {
                st = environment.createStatementWithBoundFixtureSymbols(statment);
                st.execute();
            }
            catch (Throwable e) {
                throw new DbFitException("there are some error when execute sql file.", e);
            }
            finally {
                DBHelper.closeStatement(st);
            }
        }
    }

    public static void executeFromFile(Class clazz, String fileName) {
        String[] statements;
        String sqls;
        DBEnvironment environment = DBEnvironmentFactory.getCurrentDBEnvironment();
        environment.connectIfNeeded();
        try {
            sqls = ResourceHelper.readFromFile(clazz, fileName);
        }
        catch (FileNotFoundException e1) {
            throw new RuntimeException(e1);
        }
        for (String statment : statements = DBHelper.parseSQL(sqls)) {
            PreparedStatement st = null;
            try {
                st = environment.createStatementWithBoundFixtureSymbols(statment);
                st.execute();
            }
            catch (Throwable e) {
                throw new DbFitException("there are some error when execute sql file [" + fileName + "]", e);
            }
            finally {
                DBHelper.closeStatement(st);
            }
        }
    }

    public static <T> T query(String sql, Class<T> claz) {
        T t;
        ResultSetMetaData rsmd;
        ResultSet rs;
        PreparedStatement st;
        block6: {
            Map value;
            DBEnvironment environment = DBEnvironmentFactory.getCurrentDBEnvironment();
            environment.connectIfNeeded();
            st = null;
            rs = null;
            st = environment.createStatementWithBoundFixtureSymbols(sql);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new RuntimeException("there are no result for statement:" + sql);
            }
            rsmd = rs.getMetaData();
            if (!Map.class.isAssignableFrom(claz)) break block6;
            Map map = value = DBHelper.getMapFromResult(rs, rsmd, false);
            DBHelper.closeResultSet(rs);
            DBHelper.closeStatement(st);
            return (T)map;
        }
        try {
            T pojo;
            t = pojo = DBHelper.getPoJoFromResult(rs, rsmd, claz);
        }
        catch (Throwable e) {
            try {
                throw ExceptionWrapper.getUndeclaredThrowableExceptionCaused(e);
            }
            catch (Throwable throwable) {
                DBHelper.closeResultSet(rs);
                DBHelper.closeStatement(st);
                throw throwable;
            }
        }
        DBHelper.closeResultSet(rs);
        DBHelper.closeStatement(st);
        return t;
    }

    public static <T> List<T> queryList(String sql, Class<T> clazz) {
        List<T> list;
        ResultSetMetaData rsmd;
        ResultSet rs;
        PreparedStatement st;
        block5: {
            List<Map> maps;
            DBEnvironment environment = DBEnvironmentFactory.getCurrentDBEnvironment();
            environment.connectIfNeeded();
            st = null;
            rs = null;
            st = environment.createStatementWithBoundFixtureSymbols(sql);
            rs = st.executeQuery();
            rsmd = rs.getMetaData();
            if (!Map.class.isAssignableFrom(clazz)) break block5;
            List<Map> list2 = maps = DBHelper.getListMapFromResult(rs, rsmd, false);
            DBHelper.closeResultSet(rs);
            DBHelper.closeStatement(st);
            return list2;
        }
        try {
            List<T> list3;
            list = list3 = DBHelper.getListPoJoFromResult(rs, rsmd, clazz);
        }
        catch (Throwable e) {
            try {
                throw ExceptionWrapper.getUndeclaredThrowableExceptionCaused(e);
            }
            catch (Throwable throwable) {
                DBHelper.closeResultSet(rs);
                DBHelper.closeStatement(st);
                throw throwable;
            }
        }
        DBHelper.closeResultSet(rs);
        DBHelper.closeStatement(st);
        return list;
    }

    public static <T> List<T> queryMapList(String sql) {
        List<Map> list;
        DBEnvironment environment = DBEnvironmentFactory.getCurrentDBEnvironment();
        environment.connectIfNeeded();
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            List<Map> maps;
            st = environment.createStatementWithBoundFixtureSymbols(sql);
            rs = st.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            list = maps = DBHelper.getListMapFromResult(rs, rsmd, false);
        }
        catch (Throwable e) {
            try {
                throw ExceptionWrapper.getUndeclaredThrowableExceptionCaused(e);
            }
            catch (Throwable throwable) {
                DBHelper.closeResultSet(rs);
                DBHelper.closeStatement(st);
                throw throwable;
            }
        }
        DBHelper.closeResultSet(rs);
        DBHelper.closeStatement(st);
        return list;
    }

    public static <T> List<T> queryMapList(String sql, IJTester.DataMap where) {
        List<Map> list;
        DBEnvironment environment = DBEnvironmentFactory.getCurrentDBEnvironment();
        environment.connectIfNeeded();
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            List<Map> maps;
            st = environment.createStatementWithBoundFixtureSymbols(sql);
            int index = 1;
            for (String key : where.keySet()) {
                try {
                    Object value = where.get(key);
                    if (value instanceof InputStream) {
                        InputStream is = (InputStream)value;
                        st.setBinaryStream(index, is, is.available());
                    } else {
                        st.setObject(index, value);
                    }
                    ++index;
                }
                catch (Throwable e) {
                    throw new RuntimeException("set column[" + key + "] value error:" + e.getMessage(), e);
                }
            }
            rs = st.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            list = maps = DBHelper.getListMapFromResult(rs, rsmd, false);
        }
        catch (Throwable e) {
            try {
                throw ExceptionWrapper.getUndeclaredThrowableExceptionCaused(e);
            }
            catch (Throwable throwable) {
                DBHelper.closeResultSet(rs);
                DBHelper.closeStatement(st);
                throw throwable;
            }
        }
        DBHelper.closeResultSet(rs);
        DBHelper.closeStatement(st);
        return list;
    }

    public static <T> Map<String, Object> queryMap(String sql) {
        List<T> list = SqlRunner.queryMapList(sql);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new RuntimeException("to many result, u want to query one RowSet.");
        }
        return (Map)list.get(0);
    }
}

