/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jtester.annotations.DbFit;
import org.jtester.utility.AnnotationUtils;
import org.jtester.utility.ResourceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoFindDbFit {
    public static final String METHOD_WHEN_WIKI = "data/%s/%s.when.wiki";
    public static final String METHOD_WHEN_SQL = "data/%s/%s.when.sql";
    public static final String METHOD_THEN_WIKI = "data/%s/%s.then.wiki";
    public static final String METHOD_THEN_SQL = "data/%s/%s.then.sql";
    public static final String CLAZZ_WHEN_WIKI = "data/%s.wiki";
    public static final String CLAZZ_WHEN_SQL = "data/%s.sql";

    public static String[] autoFindClassWhen(Class testClazz) {
        String sql;
        DbFit dbFit = AnnotationUtils.getClassLevelAnnotation(DbFit.class, testClazz);
        List<String> whens = AutoFindDbFit.getFiles(dbFit == null ? null : dbFit.when());
        if (dbFit != null && dbFit.auto() == DbFit.AUTO.UN_AUTO) {
            return whens.toArray(new String[0]);
        }
        String wiki = String.format(CLAZZ_WHEN_WIKI, testClazz.getSimpleName());
        if (!whens.contains(wiki) && ResourceHelper.isResourceExists(testClazz, wiki)) {
            whens.add(wiki);
        }
        if (!whens.contains(sql = String.format(CLAZZ_WHEN_SQL, testClazz.getSimpleName())) && ResourceHelper.isResourceExists(testClazz, sql)) {
            whens.add(sql);
        }
        return whens.toArray(new String[0]);
    }

    public static String[] autoFindMethodWhen(Class testClazz, Method testMethod) {
        String sql;
        boolean isAutoFind = AutoFindDbFit.isAutoFind(testClazz, testMethod);
        DbFit dbFit = testMethod.getAnnotation(DbFit.class);
        List<String> whens = AutoFindDbFit.getFiles(dbFit == null ? null : dbFit.when());
        if (!isAutoFind) {
            return whens.toArray(new String[0]);
        }
        String wiki = String.format(METHOD_WHEN_WIKI, testClazz.getSimpleName(), testMethod.getName());
        if (!whens.contains(wiki) && ResourceHelper.isResourceExists(testClazz, wiki)) {
            whens.add(wiki);
        }
        if (!whens.contains(sql = String.format(METHOD_WHEN_SQL, testClazz.getSimpleName(), testMethod.getName())) && ResourceHelper.isResourceExists(testClazz, sql)) {
            whens.add(sql);
        }
        return whens.toArray(new String[0]);
    }

    public static String[] autoFindMethodThen(Class testClazz, Method testMethod) {
        String sql;
        boolean isAutoFind = AutoFindDbFit.isAutoFind(testClazz, testMethod);
        DbFit dbFit = testMethod.getAnnotation(DbFit.class);
        List<String> thens = AutoFindDbFit.getFiles(dbFit == null ? null : dbFit.then());
        if (!isAutoFind) {
            return thens.toArray(new String[0]);
        }
        String wiki = String.format(METHOD_THEN_WIKI, testClazz.getSimpleName(), testMethod.getName());
        if (!thens.contains(wiki) && ResourceHelper.isResourceExists(testClazz, wiki)) {
            thens.add(wiki);
        }
        if (!thens.contains(sql = String.format(METHOD_THEN_SQL, testClazz.getSimpleName(), testMethod.getName())) && ResourceHelper.isResourceExists(testClazz, sql)) {
            thens.add(sql);
        }
        return thens.toArray(new String[0]);
    }

    private static boolean isAutoFind(Class testClazz, Method testMethod) {
        DbFit methodDbFit = testMethod.getAnnotation(DbFit.class);
        if (methodDbFit != null && methodDbFit.auto() != DbFit.AUTO.DEFAULT) {
            return methodDbFit.auto() == DbFit.AUTO.AUTO;
        }
        DbFit clazzDbFit = AnnotationUtils.getClassLevelAnnotation(DbFit.class, testClazz);
        if (clazzDbFit == null) {
            return true;
        }
        return clazzDbFit.auto() != DbFit.AUTO.UN_AUTO;
    }

    private static List<String> getFiles(String[] files) {
        ArrayList<String> list = new ArrayList<String>();
        if (files == null || files.length == 0) {
            return list;
        }
        for (String file : files) {
            file = file.replace('\\', '/');
            list.add(file);
        }
        return list;
    }
}

