/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit;

import fit.Fixture;
import fitlibrary.SequenceFixture;
import fitlibrary.table.Table;
import fitlibrary.utility.TestResults;
import java.sql.SQLException;
import org.jtester.core.TestedObject;
import org.jtester.core.context.DbFitContext;
import org.jtester.core.dbfit.DbFitOp;
import org.jtester.fit.util.SymbolUtil;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.environment.DBEnvironmentFactory;
import org.jtester.module.database.util.SqlRunner;
import org.jtester.module.dbfit.DbFixtureUtil;
import org.jtester.module.dbfit.db.fixture.CleanFixture;
import org.jtester.module.dbfit.db.fixture.CompareStoredQueriesFixture;
import org.jtester.module.dbfit.db.fixture.DeleteFixture;
import org.jtester.module.dbfit.db.fixture.ExecuteProcedureFixture;
import org.jtester.module.dbfit.db.fixture.InsertFixture;
import org.jtester.module.dbfit.db.fixture.InspectFixture;
import org.jtester.module.dbfit.db.fixture.QueryFixture;
import org.jtester.module.dbfit.db.fixture.QueryStatsFixture;
import org.jtester.module.dbfit.db.fixture.StoreQueryFixture;
import org.jtester.module.dbfit.db.fixture.StoreQueryTableFixture;
import org.jtester.module.dbfit.db.fixture.UpdateFixture;
import org.jtester.utility.DateUtil;
import org.jtester.utility.JTesterLogger;

public class DatabaseFixture
extends SequenceFixture
implements DbFitOp {
    static final String NO_VALID_VALUE_MESSAGE = "can't find valid value of key[%s] in file[%s]!";

    public void setUp(Table firstTable, TestResults testResults) {
        super.setUp(firstTable, testResults);
    }

    public void tearDown(Table firstTable, TestResults testResults) {
        DBEnvironment environment = this.workingEnvironment();
        try {
            JTesterLogger.info("tearDown dbfit table");
            if (environment == null) {
                return;
            }
            DbFitContext.RunIn runIn = DbFitContext.getRunIn();
            boolean isEnabledTransaction = TestedObject.isTransactionsEnabled();
            if (runIn == DbFitContext.RunIn.TestCase) {
                JTesterLogger.info("run in testcase, isEnabledTransaction:" + isEnabledTransaction);
            }
            if (runIn == DbFitContext.RunIn.TestCase && !isEnabledTransaction) {
                this.commit();
            }
            environment.teardown();
        }
        catch (Throwable e) {
            this.exception(firstTable.parse, e);
        }
        super.tearDown(firstTable, testResults);
    }

    public boolean connect() throws SQLException {
        DBEnvironment environment = this.workingEnvironment();
        environment.connect();
        return true;
    }

    public boolean connect(String type, String driver, String url, String username, String password) throws Exception {
        DBEnvironment environment = DBEnvironmentFactory.getDBEnvironment(type, driver, url, username, password);
        DBEnvironmentFactory.changeDBEnvironment(environment);
        environment.connect();
        return true;
    }

    public boolean connectFromFile(String dbname) throws Exception {
        DBEnvironment environment = DBEnvironmentFactory.getDBEnvironment(dbname);
        DBEnvironmentFactory.changeDBEnvironment(environment);
        environment.connect();
        return true;
    }

    public boolean connectFromFile(String dataSourceName, String propFile) throws Exception {
        DBEnvironment environment = DBEnvironmentFactory.getDBEnvironment(dataSourceName, propFile);
        DBEnvironmentFactory.changeDBEnvironment(environment);
        environment.connect();
        return true;
    }

    public boolean setParameter(String name, String value) {
        DbFixtureUtil.setParameter(name, value);
        return true;
    }

    public Fixture storeQuery(String query, String symbolName) {
        DBEnvironment environment = this.workingEnvironment();
        return new StoreQueryFixture(environment, query, symbolName);
    }

    public boolean setDateTimeFormat(String format) {
        String datetime = DateUtil.currDateTimeStr(format);
        DbFixtureUtil.setParameter("datetime", datetime);
        return true;
    }

    public boolean setDateFormat(String format) {
        String date = DateUtil.currDateTimeStr(format);
        DbFixtureUtil.setParameter("date", date);
        return true;
    }

    public boolean clearParameters() {
        SymbolUtil.cleanSymbols();
        return true;
    }

    public Fixture query(String query) {
        DBEnvironment environment = this.workingEnvironment();
        return new QueryFixture(environment, query);
    }

    public Fixture orderedQuery(String query) {
        DBEnvironment environment = this.workingEnvironment();
        return new QueryFixture(environment, query, true);
    }

    public boolean execute(String statement) {
        DBEnvironment environment = this.workingEnvironment();
        return DbFixtureUtil.execute(environment, statement);
    }

    public Fixture executeProcedure(String statement) {
        DBEnvironment environment = this.workingEnvironment();
        return new ExecuteProcedureFixture(environment, statement);
    }

    public Fixture executeProcedureExpectException(String statement) {
        DBEnvironment environment = this.workingEnvironment();
        return new ExecuteProcedureFixture(environment, statement, true);
    }

    public Fixture executeProcedureExpectException(String statement, int code) {
        DBEnvironment environment = this.workingEnvironment();
        return new ExecuteProcedureFixture(environment, statement, code);
    }

    public Fixture insert(String tableName) {
        DBEnvironment environment = this.workingEnvironment();
        return new InsertFixture(environment, tableName);
    }

    public Fixture update(String tableName) {
        DBEnvironment environment = this.workingEnvironment();
        return new UpdateFixture(environment, tableName);
    }

    public Fixture clean() {
        DBEnvironment environment = this.workingEnvironment();
        return new CleanFixture(environment);
    }

    public boolean cleanTable(String tables) {
        String[] ts;
        DBEnvironment environment = this.workingEnvironment();
        for (String table : ts = tables.split("[;,]")) {
            DbFixtureUtil.cleanTable(environment, table);
        }
        return true;
    }

    public Fixture delete(String table) {
        DBEnvironment environment = this.workingEnvironment();
        return new DeleteFixture(environment, table);
    }

    public boolean rollback() throws SQLException {
        DBEnvironment environment = this.workingEnvironment();
        environment.rollback();
        environment.getConnection().setAutoCommit(false);
        return true;
    }

    public boolean commit() throws SQLException {
        DBEnvironment environment = this.workingEnvironment();
        environment.commit();
        environment.getConnection().setAutoCommit(false);
        return true;
    }

    public Fixture queryStats() {
        DBEnvironment environment = this.workingEnvironment();
        return new QueryStatsFixture(environment);
    }

    public Fixture inspectProcedure(String procName) {
        DBEnvironment environment = this.workingEnvironment();
        return new InspectFixture(environment, InspectFixture.MODE_PROCEDURE, procName);
    }

    public Fixture inspectTable(String tableName) {
        DBEnvironment environment = this.workingEnvironment();
        return new InspectFixture(environment, InspectFixture.MODE_TABLE, tableName);
    }

    public Fixture inspectView(String tableName) {
        DBEnvironment environment = this.workingEnvironment();
        return new InspectFixture(environment, InspectFixture.MODE_TABLE, tableName);
    }

    public Fixture inspectQuery(String query) {
        DBEnvironment environment = this.workingEnvironment();
        return new InspectFixture(environment, InspectFixture.MODE_QUERY, query);
    }

    public Fixture storeQueryTable(String query, String symbolName) {
        DBEnvironment environment = this.workingEnvironment();
        return new StoreQueryTableFixture(environment, query, symbolName);
    }

    public Fixture compareStoredQueries(String symbol1, String symbol2) {
        DBEnvironment environment = this.workingEnvironment();
        return new CompareStoredQueriesFixture(environment, symbol1, symbol2);
    }

    public boolean executeFile(String file) throws Exception {
        SqlRunner.executeFromFile(file);
        return true;
    }

    public DBEnvironment workingEnvironment() {
        DBEnvironment environment = DBEnvironmentFactory.getCurrentDBEnvironment();
        return environment;
    }
}

