/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit;

import java.util.Map;
import org.jtester.exception.DbFitException;
import org.jtester.fit.FitRunner;
import org.jtester.fit.util.SymbolUtil;
import org.jtester.module.dbfit.DatabaseFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbFitRunner
extends FitRunner {
    private static DbFitRunner defaultRunner = new DbFitRunner();

    public DbFitRunner() {
    }

    public DbFitRunner(String dbfitDir) {
        super(dbfitDir);
    }

    public void runDbFitTest(Class claz, String url) {
        try {
            this.runFitTest(claz, url);
        }
        catch (Throwable e) {
            throw new DbFitException("run wiki[" + url + "] error.", e);
        }
    }

    @Override
    protected String decoratedWiki(String wiki) {
        if (wiki.contains(DatabaseFixture.class.getName())) {
            return wiki;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.format("|!-%s-!|", DatabaseFixture.class.getName()));
        buffer.append("\n");
        buffer.append(wiki);
        return buffer.toString();
    }

    public static void runDbFit(Class clazz, String wiki, String ... wikis) {
        defaultRunner.runDbFitTest(clazz, wiki);
        for (String curr : wikis) {
            defaultRunner.runDbFitTest(clazz, curr);
        }
    }

    public static void runDbFit(Class clazz, boolean cleanSymbols, String wiki, String ... wikis) {
        DbFitRunner.runDbFit(clazz, wiki, wikis);
        if (cleanSymbols) {
            SymbolUtil.cleanSymbols();
        }
    }

    public static void runDbFit(Class clazz, Map<String, ?> symbols, String wiki, String ... wikis) {
        SymbolUtil.setSymbol(symbols);
        DbFitRunner.runDbFit(clazz, wiki, wikis);
    }

    public static void runDbFit(Class clazz, Map<String, Object> symbols, boolean cleanSymbols, String wiki, String ... wikis) {
        DbFitRunner.runDbFit(clazz, symbols, wiki, wikis);
        if (cleanSymbols) {
            SymbolUtil.cleanSymbols();
        }
    }
}

