/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit;

import java.sql.PreparedStatement;
import org.jtester.fit.util.SymbolUtil;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.util.DBHelper;

public class DbFixtureUtil {
    public static final boolean execute(DBEnvironment dbEnvironment, String statement) {
        PreparedStatement st = null;
        try {
            st = dbEnvironment.createStatementWithBoundFixtureSymbols(statement);
            st.execute();
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            DBHelper.closeStatement(st);
            st = null;
        }
    }

    public static void cleanTable(DBEnvironment env, String table) {
        PreparedStatement st = null;
        try {
            String statement = String.format("delete from %s ", table);
            st = env.createStatementWithBoundFixtureSymbols(statement);
            st.execute();
        }
        catch (Throwable e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DBHelper.closeStatement(st);
                st = null;
                throw throwable;
            }
        }
        DBHelper.closeStatement(st);
        st = null;
    }

    public static void setParameter(String name, String value) {
        if (value == null || "<null>".equals(value.toString().toLowerCase())) {
            SymbolUtil.setSymbol(name, null);
        } else if (value != null && value.toString().startsWith("<<")) {
            String varname = value.toString().substring(2);
            if (!name.equals(varname)) {
                SymbolUtil.setSymbol(name, SymbolUtil.getSymbol(varname));
            }
        } else {
            SymbolUtil.setSymbol(name, value);
        }
    }
}

