/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class FileHelper {
    private static final int BUFFER_SIZE = 4096;
    private static final String FITNESSE_ROOT_DIR = "FitNesseRoot";
    private static final String FILES = "files";
    private static final String FILES_DIR = File.separatorChar + "files" + File.separatorChar;

    private FileHelper() {
    }

    public static File getFile(String fileName) {
        String platformFileName = fileName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        File file = platformFileName.startsWith(FILES_DIR) ? new File(FITNESSE_ROOT_DIR + platformFileName) : (platformFileName.startsWith(File.separator) || platformFileName.length() >= 2 && Character.isLetter(platformFileName.charAt(0)) && platformFileName.charAt(1) == ':' ? new File(platformFileName) : new File(FITNESSE_ROOT_DIR + FILES_DIR + platformFileName));
        return file;
    }

    public static InputStream getFileAsStream(String fileName) throws FileNotFoundException {
        File file = FileHelper.getFile(fileName);
        FileInputStream fis = new FileInputStream(file);
        return fis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileAsString(String fileName) throws IOException {
        InputStream fis = FileHelper.getFileAsStream(fileName);
        StringBuffer sb = new StringBuffer();
        char[] buf = new char[4096];
        int len = 0;
        InputStreamReader reader = new InputStreamReader(fis);
        try {
            while ((len = reader.read(buf)) > 0) {
                sb.append(buf, 0, len);
            }
        }
        finally {
            reader.close();
        }
        return sb.toString();
    }
}

