/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit.db.fixture;

import fit.ColumnFixture;
import fit.Parse;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.util.DBHelper;

public class CleanFixture
extends ColumnFixture {
    private DBEnvironment environment;
    public String table;
    public String columnName;
    public BigDecimal[] ids;
    public String[] keys;
    public String where = null;
    private boolean hadRowOperation = false;

    public CleanFixture(DBEnvironment environment) {
        this.environment = environment;
    }

    private String getIDCSV() {
        StringBuilder sb = new StringBuilder();
        String comma = "";
        for (BigDecimal x : this.ids) {
            sb.append(comma);
            sb.append(x.toString());
            comma = ", ";
        }
        return sb.toString();
    }

    private String getKeyCSV() {
        StringBuilder sb = new StringBuilder();
        String comma = "";
        for (String x : this.keys) {
            sb.append(comma);
            sb.append("'");
            sb.append(x.toString());
            sb.append("'");
            comma = ", ";
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clean() throws SQLException {
        boolean bl;
        String s = "Delete from " + this.table + (this.where != null ? " where " + this.where : "");
        PreparedStatement statement = null;
        try {
            statement = this.environment.createStatementWithBoundFixtureSymbols(s);
            statement.execute();
            bl = true;
        }
        catch (Throwable throwable) {
            DBHelper.closeStatement(statement);
            statement = null;
            throw throwable;
        }
        DBHelper.closeStatement(statement);
        statement = null;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean DeleteRowsForIDs() throws SQLException {
        boolean bl;
        String s = "Delete from " + this.table + " where " + this.columnName + " in (" + this.getIDCSV() + ") " + (this.where != null ? " and " + this.where : "");
        PreparedStatement statement = null;
        try {
            statement = this.environment.createStatementWithBoundFixtureSymbols(s);
            statement.execute();
            this.hadRowOperation = true;
            bl = true;
        }
        catch (Throwable throwable) {
            DBHelper.closeStatement(statement);
            statement = null;
            throw throwable;
        }
        DBHelper.closeStatement(statement);
        statement = null;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean DeleteRowsForKeys() throws SQLException {
        boolean bl;
        String s = "Delete from " + this.table + " where " + this.columnName + " in (" + this.getKeyCSV() + ") " + (this.where != null ? " and " + this.where : "");
        PreparedStatement statement = null;
        try {
            statement = this.environment.createStatementWithBoundFixtureSymbols(s);
            statement.execute();
            this.hadRowOperation = true;
            bl = true;
        }
        catch (Throwable throwable) {
            DBHelper.closeStatement(statement);
            statement = null;
            throw throwable;
        }
        DBHelper.closeStatement(statement);
        statement = null;
        return bl;
    }

    public void doRow(Parse row) {
        this.hadRowOperation = false;
        super.doRow(row);
        if (!this.hadRowOperation) {
            try {
                this.clean();
            }
            catch (SQLException sqle) {
                this.exception(row, sqle);
            }
        }
    }
}

