/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit.db.fixture;

import fit.Fixture;
import fit.Parse;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import org.jtester.exception.NoMatchingRowFoundException;
import org.jtester.fit.JTesterFixture;
import org.jtester.fit.util.SymbolUtil;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.environment.normalise.NameNormaliser;
import org.jtester.module.database.util.DBHelper;
import org.jtester.module.dbfit.db.model.DataRow;
import org.jtester.module.dbfit.db.model.DataTable;

public class CompareStoredQueriesFixture
extends JTesterFixture {
    private String symbol1;
    private String symbol2;
    private DataTable dt1;
    private DataTable dt2;
    private String[] columnNames;
    private boolean[] keyProperties;

    public CompareStoredQueriesFixture() {
    }

    public CompareStoredQueriesFixture(DBEnvironment environment, String symbol1, String symbol2) {
        this.symbol1 = symbol1;
        this.symbol2 = symbol2;
    }

    private DataTable getDataTable(String symbolName) {
        Object o = SymbolUtil.getSymbol(symbolName);
        if (o == null) {
            throw new UnsupportedOperationException("Cannot load a stored query from " + symbolName);
        }
        if (o instanceof DataTable) {
            return (DataTable)o;
        }
        ResultSet rs = null;
        if (!(o instanceof ResultSet)) {
            throw new UnsupportedOperationException("Cannot load stored query from " + symbolName + " - object type is " + o.getClass().getName());
        }
        rs = (ResultSet)o;
        try {
            DataTable dt;
            DataTable dataTable = dt = new DataTable(rs);
            return dataTable;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Cannot load stored query from " + symbolName, e);
        }
        finally {
            DBHelper.closeResultSet(rs);
            rs = null;
        }
    }

    private void initialiseDataTables() {
        if (this.symbol1 == null || this.symbol2 == null) {
            if (this.args.length < 2) {
                throw new UnsupportedOperationException("No symbols specified to CompareStoreQueries constructor or argument list");
            }
            this.symbol1 = this.args[0];
            this.symbol2 = this.args[1];
        }
        if (this.symbol1.startsWith("<<")) {
            this.symbol1 = this.symbol1.substring(2);
        }
        if (this.symbol2.startsWith("<<")) {
            this.symbol2 = this.symbol2.substring(2);
        }
        this.dt1 = this.getDataTable(this.symbol1);
        this.dt2 = this.getDataTable(this.symbol2);
    }

    public void doTable(Parse table) {
        this.initialiseDataTables();
        Parse lastRow = table.parts.more;
        if (lastRow == null) {
            throw new Error("Query structure missing from second row");
        }
        this.loadRowStructure(lastRow);
        lastRow = this.processDataTable(this.dt1, this.dt2, lastRow, this.symbol2);
        List<DataRow> unproc = this.dt2.getUnprocessedRows();
        for (DataRow dr : unproc) {
            lastRow = this.addRow(lastRow, dr, true, " missing from " + this.symbol1);
        }
    }

    private void loadRowStructure(Parse headerRow) {
        Parse headerCell = headerRow.parts;
        int colNum = headerRow.parts.size();
        this.columnNames = new String[colNum];
        this.keyProperties = new boolean[colNum];
        for (int i = 0; i < colNum; ++i) {
            String currentName = headerCell.text();
            if (currentName == null) {
                throw new UnsupportedOperationException("Column " + i + " does not have a name");
            }
            if ((currentName = currentName.trim()).length() == 0) {
                throw new UnsupportedOperationException("Column " + i + " does not have a name");
            }
            this.columnNames[i] = NameNormaliser.normaliseName(currentName);
            this.keyProperties[i] = !currentName.endsWith("?");
            headerCell = headerCell.more;
        }
    }

    private Parse processDataTable(DataTable t1, DataTable t2, Parse lastScreenRow, String queryName) {
        List<DataRow> unproc = t1.getUnprocessedRows();
        for (DataRow dr : unproc) {
            HashMap<String, Object> matchingMask = new HashMap<String, Object>();
            for (int i = 0; i < this.keyProperties.length; ++i) {
                if (!this.keyProperties[i]) continue;
                matchingMask.put(this.columnNames[i], dr.get(this.columnNames[i]));
            }
            try {
                DataRow dr2 = t2.findMatching(matchingMask);
                dr2.markProcessed();
                lastScreenRow = this.addRow(lastScreenRow, dr, dr2);
            }
            catch (NoMatchingRowFoundException nex) {
                lastScreenRow = this.addRow(lastScreenRow, dr, true, " missing from " + queryName);
            }
            dr.markProcessed();
        }
        return lastScreenRow;
    }

    private Parse addRow(Parse lastRow, DataRow dr, DataRow dr2) {
        Parse newRow;
        lastRow.more = newRow = new Parse("tr", null, null, null);
        lastRow = newRow;
        try {
            Parse firstCell;
            String lval = dr.getStringValue(this.columnNames[0]);
            String rval = dr2.getStringValue(this.columnNames[0]);
            newRow.parts = firstCell = new Parse("td", lval, null, null);
            if (!lval.equals(rval)) {
                this.wrong(firstCell, rval);
            } else {
                this.right(firstCell);
            }
            for (int i = 1; i < this.columnNames.length; ++i) {
                Parse nextCell;
                lval = dr.getStringValue(this.columnNames[i]);
                rval = dr2.getStringValue(this.columnNames[i]);
                firstCell.more = nextCell = new Parse("td", lval, null, null);
                firstCell = nextCell;
                if (!lval.equals(rval)) {
                    this.wrong(firstCell, rval);
                    continue;
                }
                this.right(firstCell);
            }
        }
        catch (Throwable e) {
            this.exception(newRow, e);
        }
        return lastRow;
    }

    private Parse addRow(Parse lastRow, DataRow dr, boolean markAsError, String desc) {
        Parse newRow;
        lastRow.more = newRow = new Parse("tr", null, null, null);
        lastRow = newRow;
        try {
            Parse firstCell;
            newRow.parts = firstCell = new Parse("td", dr.getStringValue(this.columnNames[0]), null, null);
            if (markAsError) {
                firstCell.addToBody(Fixture.gray((String)desc));
                this.wrong(firstCell);
            }
            for (int i = 1; i < this.columnNames.length; ++i) {
                Parse nextCell;
                firstCell.more = nextCell = new Parse("td", dr.getStringValue(this.columnNames[i]), null, null);
                firstCell = nextCell;
            }
        }
        catch (Throwable e) {
            this.exception(newRow, e);
        }
        return lastRow;
    }
}

