/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit.db.fixture;

import fit.Fixture;
import fit.Parse;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jtester.exception.HasMarkedException;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.util.DBHelper;
import org.jtester.module.dbfit.db.fixture.InsertFixture;
import org.jtester.module.dbfit.db.model.DbParameterAccessor;

public class DeleteFixture
extends InsertFixture {
    public DeleteFixture(DBEnvironment env, String tableName) {
        super(env, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRows(Parse rows) {
        if ((this.tableName == null || this.tableName.trim().length() == 0) && this.args.length > 0) {
            this.tableName = this.args[0];
        } else if (this.tableName == null) {
            this.tableName = rows.parts.text();
            rows = rows.more;
        }
        PreparedStatement statement = null;
        try {
            this.initParameters(rows.parts);
            statement = this.buildDeleteCommand(this.tableName, this.accessors);
            Parse row = rows;
            while ((row = row.more) != null) {
                this.deleteRowData(statement, row);
                this.right(row);
            }
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
                if (!(e instanceof HasMarkedException)) {
                    this.exception(rows.parts, e);
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                DBHelper.closeStatement(statement);
                statement = null;
            }
        }
        DBHelper.closeStatement(statement);
        statement = null;
    }

    public PreparedStatement buildDeleteCommand(String tableName, DbParameterAccessor[] accessors) throws SQLException {
        String delete = this.environment.buildDeleteCommand(tableName, accessors);
        PreparedStatement cs = this.environment.supportsOuputOnInsert() ? this.environment.getConnection().prepareCall(delete) : this.environment.getConnection().prepareStatement(delete, 1);
        for (int i = 0; i < accessors.length; ++i) {
            accessors[i].bindTo(this, cs, i + 1);
        }
        return cs;
    }

    protected void deleteRowData(PreparedStatement statement, Parse row) {
        Parse cell = row.parts;
        try {
            statement.clearParameters();
            for (int column = 0; column < this.accessors.length; ++column) {
                int direction = this.accessors[column].getDirection();
                if (direction == 1) {
                    this.columnBindings[column].doCell((Fixture)this, cell);
                }
                cell = cell.more;
            }
            statement.execute();
        }
        catch (Throwable e) {
            this.exception(cell, e);
            throw new HasMarkedException(e);
        }
    }
}

