/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit.db.fixture;

import fit.Binding;
import fit.Fixture;
import fit.Parse;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jtester.exception.HasMarkedException;
import org.jtester.fit.JTesterFixture;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.environment.normalise.NameNormaliser;
import org.jtester.module.database.util.DBHelper;
import org.jtester.module.dbfit.db.model.DbParameterAccessor;
import org.jtester.module.dbfit.db.model.SymbolAccessQueryBinding;
import org.jtester.module.dbfit.db.model.SymbolAccessSetBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteProcedureFixture
extends JTesterFixture {
    private DBEnvironment environment;
    private String procName;
    private DbParameterAccessor[] accessors;
    private Binding[] columnBindings;
    private boolean exceptionExpected = false;
    private boolean excNumberDefined = false;
    private int excNumberExpected;
    private Parse headerRow;

    public ExecuteProcedureFixture(DBEnvironment dbEnvironment, String procName, int expectedErrorCode) {
        this.procName = procName;
        this.environment = dbEnvironment;
        this.exceptionExpected = true;
        this.excNumberDefined = true;
        this.excNumberExpected = expectedErrorCode;
    }

    public ExecuteProcedureFixture(DBEnvironment dbEnvironment, String procName, boolean exceptionExpected) {
        this.procName = procName;
        this.environment = dbEnvironment;
        this.exceptionExpected = exceptionExpected;
        this.excNumberDefined = false;
    }

    public ExecuteProcedureFixture(DBEnvironment dbEnvironment, String procName) {
        this(dbEnvironment, procName, false);
    }

    List<String> getSortedAccessorNames(DbParameterAccessor[] accessors) {
        DbParameterAccessor[] newacc = new DbParameterAccessor[accessors.length];
        System.arraycopy(accessors, 0, newacc, 0, accessors.length);
        Arrays.sort(newacc, new PositionComparator());
        ArrayList<String> nameList = new ArrayList<String>();
        String lastName = null;
        for (DbParameterAccessor p : newacc) {
            if (lastName == p.getName()) continue;
            lastName = p.getName();
            nameList.add(p.getName());
        }
        return nameList;
    }

    private boolean containsReturnValue(DbParameterAccessor[] accessors) {
        for (DbParameterAccessor ac : accessors) {
            if (ac.getDirection() != 0) continue;
            return true;
        }
        return false;
    }

    public CallableStatement buildCommand(String procName, DbParameterAccessor[] accessors) throws SQLException {
        int i;
        List<String> accessorNames = this.getSortedAccessorNames(accessors);
        boolean isFunction = this.containsReturnValue(accessors);
        StringBuilder ins = new StringBuilder("{ ");
        if (isFunction) {
            ins.append("? =");
        }
        ins.append("call ").append(procName);
        String comma = "(";
        boolean hasArguments = false;
        int n = i = isFunction ? 1 : 0;
        while (i < accessorNames.size()) {
            ins.append(comma);
            ins.append("?");
            comma = ",";
            hasArguments = true;
            ++i;
        }
        if (hasArguments) {
            ins.append(")");
        }
        ins.append("}");
        CallableStatement cs = this.environment.getConnection().prepareCall(ins.toString());
        for (DbParameterAccessor ac : accessors) {
            int realindex = accessorNames.indexOf(ac.getName());
            ac.bindTo(this, cs, realindex + 1);
        }
        return cs;
    }

    public void doTable(Parse table) {
        this.headerRow = table.parts;
        try {
            super.doTable(table);
        }
        catch (Throwable e) {
            this.exception(this.headerRow, e);
        }
    }

    public void doRows(Parse rows) {
        if ((this.procName == null || this.procName.trim().length() == 0) && this.args.length > 0) {
            this.procName = this.args[0];
        }
        if (rows != null) {
            this.executeStatementForEachRow(rows);
        } else {
            this.executeUsingHeaderRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUsingHeaderRow() {
        CallableStatement statement;
        block5: {
            statement = null;
            try {
                this.accessors = new DbParameterAccessor[0];
                statement = this.buildCommand(this.procName, this.accessors);
                if (!this.exceptionExpected) {
                    statement.execute();
                    break block5;
                }
                this.executeExpectingException(statement, this.headerRow);
            }
            catch (SQLException e) {
                try {
                    this.exception(this.headerRow, e);
                    this.headerRow.parts.last().more = new Parse("td", e.getMessage(), null, null);
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    DBHelper.closeStatement(statement);
                    statement = null;
                    throw throwable;
                }
                DBHelper.closeStatement(statement);
                statement = null;
            }
        }
        DBHelper.closeStatement(statement);
        statement = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStatementForEachRow(Parse rows) {
        CallableStatement statement = null;
        try {
            this.initParameters(rows.parts);
            statement = this.buildCommand(this.procName, this.accessors);
            Parse row = rows;
            while ((row = row.more) != null) {
                this.runRow(statement, row);
            }
        }
        catch (Throwable e) {
            try {
                this.exception(rows.parts, e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                DBHelper.closeStatement(statement);
                statement = null;
            }
        }
        DBHelper.closeStatement(statement);
        statement = null;
    }

    private void initParameters(Parse headerCells) throws SQLException {
        Map<String, DbParameterAccessor> allParams = this.environment.getAllProcedureParameters(this.procName);
        if (allParams.isEmpty()) {
            throw new SQLException("Cannot retrieve list of parameters for " + this.procName + " - check spelling and access rights");
        }
        this.accessors = new DbParameterAccessor[headerCells.size()];
        this.columnBindings = new Binding[headerCells.size()];
        int i = 0;
        while (headerCells != null) {
            String name = headerCells.text();
            String paramName = NameNormaliser.normaliseName(name);
            this.accessors[i] = allParams.get(paramName);
            if (this.accessors[i] == null) {
                throw new SQLException("Cannot find parameter for column " + i + " name=\"" + paramName + "\"");
            }
            boolean isOutput = headerCells.text().endsWith("?");
            if (this.accessors[i].getDirection() == 3) {
                this.accessors[i] = new DbParameterAccessor(this.accessors[i]);
                this.accessors[i].setDirection(isOutput ? 2 : 1);
            }
            if (isOutput) {
                this.columnBindings[i] = new SymbolAccessQueryBinding();
            } else {
                if (this.accessors[i].getDirection() == 2) {
                    this.accessors[i] = new DbParameterAccessor(this.accessors[i]);
                    this.accessors[i].setDirection(1);
                }
                this.columnBindings[i] = new SymbolAccessSetBinding();
            }
            this.columnBindings[i].adapter = this.accessors[i];
            ++i;
            headerCells = headerCells.more;
        }
    }

    private void runRow(CallableStatement statement, Parse row) {
        Parse cell = row.parts;
        try {
            int column;
            statement.clearParameters();
            for (column = 0; column < this.accessors.length; ++column) {
                if (this.accessors[column].getDirection() == 1) {
                    this.columnBindings[column].doCell((Fixture)this, cell);
                }
                cell = cell.more;
            }
            if (!this.exceptionExpected) {
                statement.execute();
                cell = row.parts;
                for (column = 0; column < this.accessors.length; ++column) {
                    if (this.accessors[column].getDirection() == 2 || this.accessors[column].getDirection() == 0) {
                        this.columnBindings[column].doCell((Fixture)this, cell);
                    }
                    cell = cell.more;
                }
            } else {
                this.executeExpectingException(statement, row);
            }
        }
        catch (Throwable e) {
            this.exception(cell, e);
            throw new HasMarkedException(e);
        }
    }

    private void executeExpectingException(CallableStatement statement, Parse row) {
        try {
            statement.execute();
            this.wrong(row);
        }
        catch (SQLException sqle) {
            if (!this.excNumberDefined) {
                this.right(row);
            }
            int realError = this.environment.getExceptionCode(sqle);
            if (realError == this.excNumberExpected) {
                this.right(row);
            }
            this.wrong(row);
            row.parts.addToBody(Fixture.gray((String)(" got error code " + realError)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PositionComparator
    implements Comparator<DbParameterAccessor> {
        private PositionComparator() {
        }

        @Override
        public int compare(DbParameterAccessor o1, DbParameterAccessor o2) {
            return (int)Math.signum(o1.getPosition() - o2.getPosition());
        }
    }
}

