/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit.db.fixture;

import fit.Binding;
import fit.Fixture;
import fit.Parse;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.jtester.exception.HasMarkedException;
import org.jtester.fit.JTesterFixture;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.environment.normalise.NameNormaliser;
import org.jtester.module.database.util.DBHelper;
import org.jtester.module.dbfit.db.model.DbAutoGeneratedKeyAccessor;
import org.jtester.module.dbfit.db.model.DbParameterAccessor;
import org.jtester.module.dbfit.db.model.SequenceAccessor;
import org.jtester.module.dbfit.db.model.SymbolAccessQueryBinding;
import org.jtester.module.dbfit.db.model.SymbolAccessSetBinding;

public class InsertFixture
extends JTesterFixture {
    protected DBEnvironment environment;
    protected String tableName;
    protected DbParameterAccessor[] accessors;
    protected Binding[] columnBindings;

    public InsertFixture(DBEnvironment dbEnvironment) {
        this.environment = dbEnvironment;
    }

    public InsertFixture(DBEnvironment dbEnvironment, String tableName) {
        this.tableName = tableName;
        this.environment = dbEnvironment;
    }

    public PreparedStatement buildInsertCommand(String tableName, DbParameterAccessor[] accessors) throws SQLException {
        String ins = this.environment.buildInsertCommand(tableName, accessors);
        boolean supportsOutputOnInsert = this.environment.supportsOuputOnInsert();
        Connection connection = this.environment.getConnection();
        PreparedStatement cs = supportsOutputOnInsert ? connection.prepareCall(ins) : connection.prepareStatement(ins, 1);
        int placeHolderIndex = 0;
        ArrayList<DbParameterAccessor> sequence = new ArrayList<DbParameterAccessor>();
        for (int i = 0; i < accessors.length; ++i) {
            int direction = accessors[i].getDirection();
            if (direction == 4) {
                sequence.add(accessors[i]);
                continue;
            }
            accessors[i].bindTo(this, cs, ++placeHolderIndex);
        }
        for (DbParameterAccessor accessor : sequence) {
            accessor.bindTo(this, cs, ++placeHolderIndex);
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRows(Parse rows) {
        if ((this.tableName == null || this.tableName.trim().length() == 0) && this.args.length > 0) {
            this.tableName = this.args[0];
        } else if (this.tableName == null) {
            this.tableName = rows.parts.text();
            rows = rows.more;
        }
        PreparedStatement statement = null;
        try {
            this.initParameters(rows.parts);
            statement = this.buildInsertCommand(this.tableName, this.accessors);
            Parse row = rows;
            int rowNum = 0;
            while ((row = row.more) != null) {
                this.insertRowData(statement, row, rowNum++);
                this.right(row);
            }
        }
        catch (Throwable e) {
            try {
                this.exception(rows.parts, e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                DBHelper.closeStatement(statement);
                statement = null;
            }
        }
        DBHelper.closeStatement(statement);
        statement = null;
    }

    protected void initParameters(Parse headerCells) throws SQLException {
        Map<String, DbParameterAccessor> allParams = this.environment.getAllColumns(this.tableName);
        if (allParams.isEmpty()) {
            throw new SQLException("Cannot retrieve list of columns for " + this.tableName + " - check spelling and access rights");
        }
        this.accessors = new DbParameterAccessor[headerCells.size()];
        this.columnBindings = new Binding[headerCells.size()];
        int i = 0;
        while (headerCells != null) {
            String name = headerCells.text();
            int question_mark = name.indexOf(63);
            String paramName = question_mark > 0 ? name.substring(0, question_mark) : name;
            paramName = NameNormaliser.normaliseName(paramName);
            this.accessors[i] = allParams.get(paramName);
            if (this.accessors[i] == null) {
                this.wrong(headerCells);
                throw new SQLException("Cannot find column " + paramName);
            }
            if (question_mark > 0) {
                this.accessors[i] = question_mark < name.length() - 1 ? new SequenceAccessor(this.accessors[i], name.substring(question_mark + 1)) : new DbAutoGeneratedKeyAccessor(this.accessors[i]);
                this.columnBindings[i] = new SymbolAccessQueryBinding();
            } else {
                this.columnBindings[i] = new SymbolAccessSetBinding();
            }
            this.columnBindings[i].adapter = this.accessors[i];
            ++i;
            headerCells = headerCells.more;
        }
    }

    protected void insertRowData(PreparedStatement statement, Parse row, int rowNum) {
        Parse cell = row.parts;
        try {
            int direction;
            int column;
            statement.clearParameters();
            for (column = 0; column < this.accessors.length; ++column) {
                direction = this.accessors[column].getDirection();
                if (direction == 1) {
                    this.columnBindings[column].doCell((Fixture)this, cell);
                }
                cell = cell.more;
            }
            statement.execute();
            cell = row.parts;
            for (column = 0; column < this.accessors.length; ++column) {
                direction = this.accessors[column].getDirection();
                if (direction == 2 || direction == 0 || direction == 4) {
                    Binding binding = this.columnBindings[column];
                    if (binding instanceof SymbolAccessQueryBinding) {
                        String keyName = this.accessors[column].getName();
                        ((SymbolAccessQueryBinding)binding).doCell(this, cell, keyName, rowNum);
                    } else {
                        this.columnBindings[column].doCell((Fixture)this, cell);
                    }
                }
                cell = cell.more;
            }
        }
        catch (Throwable e) {
            this.exception(cell, e);
            throw new HasMarkedException(e);
        }
    }
}

