/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit.db.fixture;

import fit.Fixture;
import fit.Parse;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.jtester.fit.JTesterFixture;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.util.DBHelper;
import org.jtester.module.dbfit.db.model.DbParameterAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectFixture
extends JTesterFixture {
    private DBEnvironment environment;
    private String objectName;
    private String mode;
    public static String MODE_PROCEDURE = "PROCEDURE";
    public static String MODE_TABLE = "TABLE";
    public static String MODE_QUERY = "QUERY";

    public InspectFixture(DBEnvironment dbEnvironment, String mode, String objName) {
        this.objectName = objName;
        this.mode = mode;
        this.environment = dbEnvironment;
    }

    public void doTable(Parse table) {
        block6: {
            if (this.objectName == null) {
                this.objectName = this.args[0];
            }
            try {
                if (MODE_PROCEDURE.equalsIgnoreCase(this.mode)) {
                    this.inspectProcedure(table);
                    break block6;
                }
                if (MODE_TABLE.equalsIgnoreCase(this.mode)) {
                    this.inspectTable(table);
                    break block6;
                }
                if (MODE_QUERY.equalsIgnoreCase(this.mode)) {
                    this.inspectQuery(table);
                    break block6;
                }
                throw new Exception("Unknown inspect mode " + this.mode);
            }
            catch (Throwable e) {
                this.exception(table.parts.parts, e);
            }
        }
    }

    private void inspectTable(Parse table) throws SQLException {
        Map<String, DbParameterAccessor> allParams = this.environment.getAllColumns(this.objectName);
        if (allParams.isEmpty()) {
            throw new SQLException("Cannot retrieve list of columns for table or view " + this.objectName + " - check spelling and access rights");
        }
        this.addRowWithParamNames(table, allParams);
    }

    private void inspectProcedure(Parse table) throws SQLException {
        Map<String, DbParameterAccessor> allParams = this.environment.getAllProcedureParameters(this.objectName);
        if (allParams.isEmpty()) {
            throw new SQLException("Cannot retrieve list of parameters for procedure " + this.objectName + " - check spelling and access rights");
        }
        this.addRowWithParamNames(table, allParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inspectQuery(Parse table) throws Exception {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            Parse newRow;
            st = this.environment.createStatementWithBoundFixtureSymbols(this.objectName);
            rs = st.executeQuery();
            table.parts.more = newRow = this.getHeaderFromRS(rs);
            while (rs.next()) {
                newRow = newRow.more = this.getDataRow(rs);
            }
        }
        catch (Throwable throwable) {
            DBHelper.closeResultSet(rs);
            rs = null;
            DBHelper.closeStatement(st);
            st = null;
            throw throwable;
        }
        DBHelper.closeResultSet(rs);
        rs = null;
        DBHelper.closeStatement(st);
        st = null;
    }

    private Parse getDataRow(ResultSet rs) throws Exception {
        Parse newRow = new Parse("tr", null, null, null);
        ResultSetMetaData rsmd = rs.getMetaData();
        Parse prevCell = null;
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            Object value = rs.getObject(i + 1);
            Parse cell = new Parse("td", Fixture.gray((String)((value = DbParameterAccessor.normaliseValue(value)) == null ? "null" : value.toString())), null, null);
            if (prevCell == null) {
                newRow.parts = cell;
            } else {
                prevCell.more = cell;
            }
            prevCell = cell;
        }
        return newRow;
    }

    private Parse getHeaderFromRS(ResultSet rs) throws SQLException {
        Parse newRow = new Parse("tr", null, null, null);
        ResultSetMetaData rsmd = rs.getMetaData();
        Parse prevCell = null;
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            Parse cell = new Parse("td", Fixture.gray((String)rsmd.getColumnName(i + 1)), null, null);
            if (prevCell == null) {
                newRow.parts = cell;
            } else {
                prevCell.more = cell;
            }
            prevCell = cell;
        }
        return newRow;
    }

    private void addRowWithParamNames(Parse table, Map<String, DbParameterAccessor> params) {
        Parse newRow;
        table.parts.more = newRow = new Parse("tr", null, null, null);
        Parse prevCell = null;
        String[] orderedNames = new String[params.size()];
        Iterator<String> i$ = params.keySet().iterator();
        while (i$.hasNext()) {
            String s;
            orderedNames[params.get((Object)s).getPosition()] = s = i$.next();
        }
        for (int i = 0; i < orderedNames.length; ++i) {
            String name = orderedNames[i];
            if (params.get(name).getDirection() != 1) {
                name = name + "?";
            }
            Parse cell = new Parse("td", Fixture.gray((String)name), null, null);
            if (prevCell == null) {
                newRow.parts = cell;
            } else {
                prevCell.more = cell;
            }
            prevCell = cell;
        }
    }
}

