/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit.db.fixture;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.jtester.fit.util.SymbolUtil;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.util.DBHelper;
import org.jtester.module.dbfit.db.fixture.RowSetFixture;
import org.jtester.module.dbfit.db.model.DataColumn;
import org.jtester.module.dbfit.db.model.DataTable;
import org.jtester.utility.JTesterLogger;

public class QueryFixture
extends RowSetFixture {
    private DBEnvironment dbEnvironment;
    private String query;
    private boolean isOrdered;

    public QueryFixture(DBEnvironment environment, String query) {
        this(environment, query, false);
    }

    public QueryFixture(DBEnvironment environment, String query, boolean isOrdered) {
        this.dbEnvironment = environment;
        this.query = query;
        this.isOrdered = isOrdered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTable getDataTable() throws Exception {
        DataTable dataTable;
        if (this.query == null) {
            this.query = this.args[0];
        }
        if (this.query.startsWith("<<")) {
            return this.getFromSymbol();
        }
        JTesterLogger.info(String.format("Query: '%s'", this.query));
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            DataTable dt;
            st = this.dbEnvironment.createStatementWithBoundFixtureSymbols(this.query);
            rs = st.executeQuery();
            dataTable = dt = new DataTable(rs);
        }
        catch (Throwable throwable) {
            DBHelper.closeResultSet(rs);
            rs = null;
            DBHelper.closeStatement(st);
            st = null;
            throw throwable;
        }
        DBHelper.closeResultSet(rs);
        rs = null;
        DBHelper.closeStatement(st);
        st = null;
        return dataTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataTable getFromSymbol() throws Exception {
        Object o = SymbolUtil.getSymbol(this.query.substring(2).trim());
        if (o instanceof DataTable) {
            return (DataTable)o;
        }
        ResultSet rs = null;
        if (!(o instanceof ResultSet)) {
            String err = "Stored queries can only be used on symbols that contain result sets";
            throw new UnsupportedOperationException(err);
        }
        rs = (ResultSet)o;
        try {
            DataTable dt;
            DataTable dataTable = dt = new DataTable(rs);
            return dataTable;
        }
        finally {
            DBHelper.closeResultSet(rs);
            rs = null;
        }
    }

    protected boolean isOrdered() {
        return this.isOrdered;
    }

    protected Class getJavaClassForColumn(DataColumn col) {
        return this.dbEnvironment.getJavaClass(col.getDbTypeName());
    }
}

