/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit.db.fixture;

import fit.Binding;
import fit.ColumnFixture;
import fit.Fixture;
import fit.Parse;
import java.io.InputStream;
import java.util.HashMap;
import org.jtester.exception.NoMatchingRowFoundException;
import org.jtester.fit.util.ParseArg;
import org.jtester.module.database.environment.normalise.NameNormaliser;
import org.jtester.module.dbfit.db.model.DataColumn;
import org.jtester.module.dbfit.db.model.DataRow;
import org.jtester.module.dbfit.db.model.DataTable;
import org.jtester.module.dbfit.db.model.DbTypeAdapter;
import org.jtester.module.dbfit.db.model.SymbolAccessQueryBinding;
import org.jtester.utility.PrimitiveHelper;

public abstract class RowSetFixture
extends ColumnFixture {
    private DataTable dt;
    private DataRow currentRow;
    private String[] keyColumns;

    private int findColumn(String name) throws Exception {
        String normalisedName = NameNormaliser.normaliseName(name);
        for (int i = 0; i < this.dt.getColumns().size(); ++i) {
            String colName = this.dt.getColumns().get(i).getName();
            if (!normalisedName.equals(NameNormaliser.normaliseName(colName))) continue;
            return i;
        }
        throw new Exception("Unknown column " + normalisedName);
    }

    protected void bind(Parse heads) {
        try {
            this.columnBindings = new Binding[heads.size()];
            this.keyColumns = new String[heads.size()];
            int i = 0;
            while (heads != null) {
                String name = heads.text();
                this.columnBindings[i] = new SymbolAccessQueryBinding();
                int idx = this.findColumn(name);
                String columnName = this.dt.getColumns().get(idx).getName();
                if (!name.endsWith("?")) {
                    this.keyColumns[i] = columnName;
                }
                this.columnBindings[i].adapter = new CurrentDataRowTypeAdapter(columnName, this.getJavaClassForColumn(this.dt.getColumns().get(idx)));
                ++i;
                heads = heads.more;
            }
        }
        catch (Throwable sqle) {
            this.exception(heads, sqle);
        }
    }

    protected abstract DataTable getDataTable() throws Exception;

    protected abstract boolean isOrdered();

    public void doRows(Parse rows) {
        try {
            this.dt = this.getDataTable();
            super.doRows(rows);
            this.addSurplusRows(rows.last());
        }
        catch (Exception sqle) {
            sqle.printStackTrace();
            this.exception(rows, sqle);
        }
    }

    public void doRow(Parse row) {
        try {
            this.currentRow = this.isOrdered() ? this.dt.findFirstUnprocessedRow() : this.findMatchingRow(row);
            super.doRow(row);
            this.currentRow.markProcessed();
        }
        catch (NoMatchingRowFoundException e) {
            row.parts.addToBody(Fixture.gray((String)" missing"));
            this.wrong(row);
        }
    }

    public void wrong(Parse row) {
        if (row != null && row.parts != null) {
            Parse cells = row.parts;
            try {
                int i = 0;
                while (cells != null) {
                    ParseArg.parseCellValue(cells);
                    cells = cells.more;
                    ++i;
                }
            }
            catch (Throwable e) {
                this.exception(cells, e);
            }
        }
        super.wrong(row);
    }

    public DataRow findMatchingRow(Parse row) throws NoMatchingRowFoundException {
        Parse columns = row.parts;
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        for (int i = 0; i < this.keyColumns.length; ++i) {
            if (this.keyColumns[i] != null) {
                try {
                    Object value = this.columnBindings[i].adapter.parse(columns.text());
                    if (value instanceof InputStream) {
                        value = columns.text();
                    }
                    keyMap.put(this.keyColumns[i], value);
                }
                catch (Throwable e) {
                    this.exception(columns, e);
                }
            }
            columns = columns.more;
        }
        return this.dt.findMatching(keyMap);
    }

    private void addSurplusRows(Parse rows) {
        Parse lastRow = rows;
        for (DataRow dr : this.dt.getUnprocessedRows()) {
            Parse newRow;
            lastRow.more = newRow = new Parse("tr", null, null, null);
            lastRow = newRow;
            try {
                Parse firstCell;
                this.currentRow = dr;
                newRow.parts = firstCell = new Parse("td", String.valueOf(this.columnBindings[0].adapter.invoke()), null, null);
                firstCell.addToBody(Fixture.gray((String)" surplus"));
                this.wrong(firstCell);
                for (int i = 1; i < this.columnBindings.length; ++i) {
                    Parse nextCell;
                    firstCell.more = nextCell = new Parse("td", String.valueOf(this.columnBindings[i].adapter.invoke()), null, null);
                    firstCell = nextCell;
                }
            }
            catch (Throwable e) {
                this.exception(newRow, e);
            }
        }
    }

    protected Class getJavaClassForColumn(DataColumn col) {
        try {
            return Class.forName(col.getJavaClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private class CurrentDataRowTypeAdapter
    extends DbTypeAdapter {
        public String key;

        public CurrentDataRowTypeAdapter(String key, Class type) throws NoSuchMethodException {
            this.target = null;
            this.method = CurrentDataRowTypeAdapter.class.getMethod("get", new Class[0]);
            this.fixture = RowSetFixture.this;
            this.type = type;
            this.key = key;
        }

        public Object get() {
            return RowSetFixture.this.currentRow.get(this.key);
        }

        public Object invoke() throws IllegalAccessException {
            return this.get();
        }

        public boolean equals(Object a, Object b) {
            if (a instanceof Number && b instanceof Number) {
                boolean isEqual = PrimitiveHelper.doesEqual((Number)a, (Number)b);
                return isEqual;
            }
            return super.equals(a, b);
        }
    }
}

