/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit.db.fixture;

import fit.Parse;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import org.jtester.fit.JTesterFixture;
import org.jtester.fit.util.SymbolUtil;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.util.DBHelper;
import org.jtester.module.dbfit.db.model.DataRow;
import org.jtester.module.dbfit.db.model.DataTable;

public class StoreQueryFixture
extends JTesterFixture {
    private DBEnvironment dbEnvironment;
    private String query;
    private String symbolName;

    public StoreQueryFixture(DBEnvironment environment, String query, String symbolName) {
        this.dbEnvironment = environment;
        this.query = query;
        this.symbolName = symbolName;
    }

    public void doTable(Parse table) {
        if (this.query == null || this.symbolName == null) {
            if (this.args.length < 2) {
                throw new UnsupportedOperationException("No query and symbol name specified to StoreQuery constructor or argument list");
            }
            this.query = this.args[0];
            this.symbolName = this.args[1];
        }
        if (this.symbolName.startsWith(">>")) {
            this.symbolName = this.symbolName.substring(2);
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = this.dbEnvironment.createStatementWithBoundFixtureSymbols(this.query);
            rs = st.executeQuery();
            DataTable dt = new DataTable(rs);
            int rowSize = dt.getRowSize();
            if (rowSize == 0) {
                throw new RuntimeException("can't retrieve any data by query:" + this.query);
            }
            if (rowSize > 1) {
                throw new RuntimeException("allowing one row data retrieved by query:" + this.query);
            }
            int colSize = dt.getColSize();
            if (colSize == 0) {
                throw new RuntimeException("can't retrieve any column by query:" + this.query);
            }
            if (colSize > 1) {
                throw new RuntimeException("allowing one column data retrieved by query:" + this.query);
            }
            DataRow row = dt.getUnprocessedRows().get(0);
            List<String> values = row.getStringValues();
            SymbolUtil.setSymbol(this.symbolName, values.get(0));
        }
        catch (Exception sqle) {
            try {
                throw new Error(sqle);
            }
            catch (Throwable throwable) {
                DBHelper.closeResultSet(rs);
                rs = null;
                DBHelper.closeStatement(st);
                st = null;
                throw throwable;
            }
        }
        DBHelper.closeResultSet(rs);
        rs = null;
        DBHelper.closeStatement(st);
        st = null;
    }
}

