/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit.db.fixture;

import fit.Parse;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.jtester.fit.JTesterFixture;
import org.jtester.fit.util.SymbolUtil;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.util.DBHelper;
import org.jtester.module.dbfit.db.model.DataTable;

public class StoreQueryTableFixture
extends JTesterFixture {
    private DBEnvironment dbEnvironment;
    private String query;
    private String symbolName;

    public StoreQueryTableFixture(DBEnvironment environment, String query, String symbolName) {
        this.dbEnvironment = environment;
        this.query = query;
        this.symbolName = symbolName;
    }

    public void doTable(Parse table) {
        if (this.query == null || this.symbolName == null) {
            if (this.args.length < 2) {
                String err = "No query and symbol name specified to StoreQuery constructor or argument list";
                throw new UnsupportedOperationException(err);
            }
            this.query = this.args[0];
            this.symbolName = this.args[1];
        }
        if (this.symbolName.startsWith(">>")) {
            this.symbolName = this.symbolName.substring(2);
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = this.dbEnvironment.createStatementWithBoundFixtureSymbols(this.query);
            rs = st.executeQuery();
            DataTable dt = new DataTable(rs);
            SymbolUtil.setSymbol(this.symbolName, dt);
        }
        catch (Exception sqle) {
            try {
                throw new Error(sqle);
            }
            catch (Throwable throwable) {
                DBHelper.closeResultSet(rs);
                rs = null;
                DBHelper.closeStatement(st);
                st = null;
                throw throwable;
            }
        }
        DBHelper.closeResultSet(rs);
        rs = null;
        DBHelper.closeStatement(st);
        st = null;
    }
}

