/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit.db.fixture;

import fit.Binding;
import fit.Fixture;
import fit.Parse;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.jtester.exception.HasMarkedException;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.environment.normalise.NameNormaliser;
import org.jtester.module.database.util.DBHelper;
import org.jtester.module.dbfit.db.model.DbParameterAccessor;
import org.jtester.module.dbfit.db.model.SymbolAccessSetBinding;

public class UpdateFixture
extends Fixture {
    private DBEnvironment environment;
    private String tableName;
    private Binding[] columnBindings;
    private DbParameterAccessor[] updateAccessors;
    private DbParameterAccessor[] selectAccessors;

    public UpdateFixture(DBEnvironment dbEnvironment) {
        this.environment = dbEnvironment;
    }

    public UpdateFixture(DBEnvironment dbEnvironment, String tableName) {
        this.tableName = tableName;
        this.environment = dbEnvironment;
    }

    public PreparedStatement buildUpdateCommand() throws SQLException {
        int i;
        if (this.updateAccessors.length == 0) {
            String err = "Update fixture must have at least one field to update. Have you forgotten = after the column name?";
            throw new Error(err);
        }
        StringBuilder s = new StringBuilder("update ").append(this.tableName).append(" set ");
        for (i = 0; i < this.updateAccessors.length; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(this.updateAccessors[i].getName()).append("=").append("?");
        }
        s.append(" where ");
        for (i = 0; i < this.selectAccessors.length; ++i) {
            if (i > 0) {
                s.append(" and ");
            }
            s.append(this.selectAccessors[i].getName()).append("=").append("?");
        }
        PreparedStatement cs = this.environment.getConnection().prepareStatement(s.toString());
        for (int i2 = 0; i2 < this.updateAccessors.length; ++i2) {
            this.updateAccessors[i2].bindTo(this, cs, i2 + 1);
        }
        for (int j = 0; j < this.selectAccessors.length; ++j) {
            this.selectAccessors[j].bindTo(this, cs, j + this.updateAccessors.length + 1);
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRows(Parse rows) {
        if ((this.tableName == null || this.tableName.trim().length() == 0) && this.args.length > 0) {
            this.tableName = this.args[0];
        } else if (this.tableName == null) {
            this.tableName = rows.parts.text();
            rows = rows.more;
        }
        PreparedStatement statement = null;
        try {
            this.initParameters(rows.parts);
            statement = this.buildUpdateCommand();
            Parse row = rows;
            while ((row = row.more) != null) {
                this.runRow(statement, row);
            }
        }
        catch (Throwable e) {
            try {
                this.exception(rows.parts, e);
            }
            catch (Throwable throwable) {
                DBHelper.closeStatement(statement);
                statement = null;
                throw throwable;
            }
            DBHelper.closeStatement(statement);
            statement = null;
        }
        DBHelper.closeStatement(statement);
        statement = null;
    }

    private void initParameters(Parse headerCells) throws SQLException {
        Map<String, DbParameterAccessor> allParams = this.environment.getAllColumns(this.tableName);
        if (allParams.isEmpty()) {
            throw new SQLException("Cannot retrieve list of columns for " + this.tableName + " - check spelling and access rights");
        }
        this.columnBindings = new Binding[headerCells.size()];
        ArrayList<DbParameterAccessor> selectAcc = new ArrayList<DbParameterAccessor>();
        ArrayList<DbParameterAccessor> updateAcc = new ArrayList<DbParameterAccessor>();
        int i = 0;
        while (headerCells != null) {
            String name = headerCells.text();
            String paramName = NameNormaliser.normaliseName(name);
            DbParameterAccessor orig = allParams.get(paramName);
            if (orig == null) {
                this.wrong(headerCells);
                throw new SQLException("Cannot find column " + paramName);
            }
            DbParameterAccessor acc = new DbParameterAccessor(orig);
            acc.setDirection(1);
            if (headerCells.text().endsWith("=")) {
                updateAcc.add(acc);
            } else {
                selectAcc.add(acc);
            }
            this.columnBindings[i] = new SymbolAccessSetBinding();
            this.columnBindings[i].adapter = acc;
            ++i;
            headerCells = headerCells.more;
        }
        this.selectAccessors = selectAcc.toArray(new DbParameterAccessor[0]);
        this.updateAccessors = updateAcc.toArray(new DbParameterAccessor[0]);
    }

    private void runRow(PreparedStatement statement, Parse row) throws Exception {
        Parse cell = row.parts;
        try {
            statement.clearParameters();
            for (int column = 0; column < this.columnBindings.length; ++column) {
                this.columnBindings[column].doCell((Fixture)this, cell);
                cell = cell.more;
            }
            statement.execute();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            this.exception(row, sqle);
            row.parts.last().more = new Parse("td", sqle.getMessage(), null, null);
        }
        catch (Throwable e) {
            this.exception(cell, e);
            throw new HasMarkedException(e);
        }
    }
}

