/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit.db.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jtester.module.database.environment.normalise.NameNormaliser;
import org.jtester.module.dbfit.db.model.DbParameterAccessor;
import org.jtester.utility.PrimitiveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataRow {
    private Map<String, Object> values = new HashMap<String, Object>();
    private boolean processed = false;

    public Set<String> getColumnNames() {
        return this.values.keySet();
    }

    public DataRow(ResultSet rs, ResultSetMetaData rsmd) throws Exception {
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            String key = NameNormaliser.normaliseName(rsmd.getColumnName(i));
            Object temp = rs.getObject(i);
            Object value = DbParameterAccessor.normaliseValue(temp);
            this.values.put(key, value);
        }
    }

    public String getStringValue(String columnName) {
        Object o = this.values.get(columnName);
        if (o == null) {
            return "null";
        }
        return o.toString();
    }

    public List<String> getStringValues() {
        ArrayList<String> strs = new ArrayList<String>();
        for (Object o : this.values.values()) {
            strs.add(o == null ? "null" : o.toString());
        }
        return strs;
    }

    public boolean matches(Map<String, Object> keyProperties) {
        for (String key : keyProperties.keySet()) {
            Object right;
            String normalisedKey = NameNormaliser.normaliseName(key);
            if (!this.values.containsKey(normalisedKey)) {
                return false;
            }
            Object left = keyProperties.get(key);
            if (this.equals(left, right = this.values.get(normalisedKey))) continue;
            return false;
        }
        return true;
    }

    private boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof Number && b instanceof Number) {
            boolean isEqual = PrimitiveHelper.doesEqual((Number)a, (Number)b);
            return isEqual;
        }
        return a.equals(b);
    }

    public Object get(String key) {
        String normalisedKey = NameNormaliser.normaliseName(key);
        return this.values.get(normalisedKey);
    }

    public void markProcessed() {
        this.processed = true;
    }

    public boolean isProcessed() {
        return this.processed;
    }
}

