/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit.db.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jtester.exception.NoMatchingRowFoundException;
import org.jtester.module.dbfit.db.model.DataColumn;
import org.jtester.module.dbfit.db.model.DataRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTable {
    private List<DataRow> rows = new LinkedList<DataRow>();
    private List<DataColumn> columns = new LinkedList<DataColumn>();

    public DataTable(ResultSet rs) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            this.columns.add(new DataColumn(rsmd, i));
        }
        while (rs.next()) {
            this.rows.add(new DataRow(rs, rsmd));
        }
    }

    public DataRow findMatching(Map<String, Object> keyProperties) throws NoMatchingRowFoundException {
        for (DataRow dr : this.rows) {
            boolean match = !dr.isProcessed() && dr.matches(keyProperties);
            if (!match) continue;
            return dr;
        }
        throw new NoMatchingRowFoundException();
    }

    public DataRow findFirstUnprocessedRow() throws NoMatchingRowFoundException {
        for (DataRow dr : this.rows) {
            boolean process = dr.isProcessed();
            if (process) continue;
            return dr;
        }
        throw new NoMatchingRowFoundException();
    }

    public List<DataRow> getUnprocessedRows() {
        ArrayList<DataRow> l = new ArrayList<DataRow>();
        for (DataRow dr : this.rows) {
            boolean process = dr.isProcessed();
            if (process) continue;
            l.add(dr);
        }
        return l;
    }

    public List<DataColumn> getColumns() {
        return this.columns;
    }

    public int getRowSize() {
        return this.rows.size();
    }

    public int getColSize() {
        return this.columns.size();
    }
}

