/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit.db.model;

import fit.Fixture;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jtester.module.database.environment.normalise.TypeNormaliser;
import org.jtester.module.database.environment.normalise.TypeNormaliserFactory;
import org.jtester.module.dbfit.db.model.DbTypeAdapter;

public class DbParameterAccessor
extends DbTypeAdapter {
    public static final int RETURN_VALUE = 0;
    public static final int INPUT = 1;
    public static final int OUTPUT = 2;
    public static final int INPUT_OUTPUT = 3;
    public static final int SEQUENCE = 4;
    private int index;
    private int direction;
    private String name;
    private String placeholder = "?";
    private int sqlType;
    private int position;
    private PreparedStatement cs;

    public static Object normaliseValue(Object currVal) throws Exception {
        if (currVal == null) {
            return null;
        }
        TypeNormaliser tn = TypeNormaliserFactory.getNormaliser(currVal.getClass());
        if (tn != null) {
            currVal = tn.normalise(currVal);
        }
        return currVal;
    }

    public DbParameterAccessor(DbParameterAccessor acc) {
        this.name = acc.name;
        this.direction = acc.direction;
        this.sqlType = acc.sqlType;
        this.type = acc.type;
        this.position = acc.position;
    }

    public DbParameterAccessor(String name, int direction, int sqlType, Class javaType, int position) {
        this.name = name;
        this.direction = direction;
        this.sqlType = sqlType;
        this.type = javaType;
        this.position = position;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public int getDirection() {
        return this.direction;
    }

    public String getName() {
        return this.name;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    private CallableStatement convertStatementToCallable() throws SQLException {
        if (this.cs instanceof CallableStatement) {
            return (CallableStatement)this.cs;
        }
        throw new SQLException("This operation requires a callable statement instead of " + this.cs.getClass().getName());
    }

    public void bindTo(Fixture f, PreparedStatement cs, int ind) throws SQLException {
        boolean tocall;
        this.cs = cs;
        this.fixture = f;
        this.index = ind;
        boolean bl = tocall = this.direction == 2 || this.direction == 0 || this.direction == 3;
        if (tocall) {
            this.convertStatementToCallable().registerOutParameter(ind, this.getSqlType());
        }
    }

    public void set(Object value) throws Exception {
        if (this.direction == 2 || this.direction == 0) {
            throw new UnsupportedOperationException("Trying to set value of output parameter " + this.name);
        }
        if (value instanceof InputStream) {
            InputStream is = (InputStream)value;
            this.cs.setBinaryStream(this.index, is, is.available());
        } else {
            this.cs.setObject(this.index, value);
        }
    }

    public Object get() throws IllegalAccessException, InvocationTargetException {
        try {
            if (this.direction == 1) {
                String err = "Trying to get value of input parameter " + this.name;
                throw new UnsupportedOperationException(err);
            }
            CallableStatement statment = this.convertStatementToCallable();
            Object o = statment.getObject(this.index);
            return DbParameterAccessor.normaliseValue(o);
        }
        catch (Exception sqle) {
            throw new InvocationTargetException(sqle);
        }
    }

    public int getPosition() {
        return this.position;
    }
}

