/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.dbfit.db.model;

import fit.Binding;
import fit.Fixture;
import fit.Parse;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jtester.fit.util.ParseArg;
import org.jtester.fit.util.SymbolUtil;
import org.jtester.utility.StringHelper;

public class SymbolAccessQueryBinding
extends Binding.QueryBinding {
    boolean symbol_has_set = false;

    public void doCell(Fixture fixture, Parse cell, String symbolName, int rowNum) {
        this.symbol_has_set = false;
        String content = cell.text();
        if (content.startsWith(">>")) {
            try {
                Object value = this.adapter.get();
                this.setSymbols(content, symbolName, value, rowNum);
                this.symbol_has_set = true;
            }
            catch (Throwable t) {
                fixture.exception(cell, t);
                return;
            }
        }
        this.doCell(fixture, cell);
    }

    public void doCell(Fixture fixture, Parse cell) {
        String content = cell.text();
        try {
            if (content.startsWith(">>")) {
                Object value = this.adapter.get();
                if (!this.symbol_has_set) {
                    SymbolUtil.setSymbol(content.substring(2).trim(), value);
                }
                cell.addToBody(Fixture.gray((String)("= " + String.valueOf(value))));
                return;
            }
            String value = ParseArg.parseCellValue(cell);
            Object actual = this.adapter.get();
            if (content.startsWith("fail[") || content.endsWith("]")) {
                String expectedVal = value.substring(5, value.length() - 1);
                Object expected = this.adapter.parse(expectedVal);
                if (this.adapter.equals(actual, expected)) {
                    fixture.wrong(cell, String.valueOf(value));
                } else {
                    fixture.right(cell);
                }
            } else {
                Object expected = this.adapter.parse(value);
                if (expected instanceof InputStream) {
                    expected = value;
                }
                if (expected instanceof Date && actual instanceof Date) {
                    long time_actual;
                    long time_expected = ((Date)expected).getTime();
                    if (time_expected == (time_actual = ((Date)actual).getTime())) {
                        fixture.right(cell);
                    } else {
                        fixture.wrong(cell, String.valueOf(value));
                    }
                } else if (this.adapter.equals(actual, expected)) {
                    fixture.right(cell);
                } else {
                    fixture.wrong(cell, String.valueOf(value));
                }
            }
        }
        catch (Throwable t) {
            fixture.exception(cell, t);
            return;
        }
    }

    private void setSymbols(String content, String idName, Object value, int rowNum) throws IllegalAccessException, InvocationTargetException {
        Object symbol;
        content = content.substring(2);
        String keyName = String.valueOf(rowNum);
        int index = content.indexOf("[");
        String symbolName = idName;
        if (index > -1) {
            symbolName = StringHelper.trim(content.substring(0, index));
            keyName = StringHelper.trim(content.substring(index + 1, content.length() - 1));
        } else if (content.length() > 1) {
            symbolName = StringHelper.trim(content.substring(1));
        }
        if (StringHelper.isBlankOrNull(symbolName)) {
            symbolName = idName;
        }
        if ((symbol = SymbolUtil.getSymbol(symbolName)) instanceof Map) {
            Map map = (Map)symbol;
            map.put(keyName, value);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(keyName, value);
            SymbolUtil.setSymbol(symbolName, map);
        }
    }
}

