/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.jmockit;

import ext.jtester.hamcrest.StringDescription;
import mockit.Expectations;
import mockit.Verifications;
import mockit.external.hamcrest.BaseMatcher;
import mockit.external.hamcrest.Description;
import mockit.external.hamcrest.Matcher;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.TestOnlyPhase;
import mockit.internal.state.TestRun;

public class ExpectationsUtil {
    private static ThreadLocal<Object> jes = new ThreadLocal();

    public static void register(Expectations ex) {
        jes.set(ex);
    }

    public static void register(Verifications ve) {
        jes.set(ve);
    }

    public static boolean isJmockitExpectations() {
        Object ex = jes.get();
        return ex == null ? false : ex instanceof Expectations;
    }

    public static boolean isJmockitVerifications() {
        Object ex = jes.get();
        return ex == null ? false : ex instanceof Verifications;
    }

    public static void addArgMatcher(ext.jtester.hamcrest.Matcher matcher) {
        RecordAndReplayExecution instance = TestRun.getRecordAndReplayForRunningTest((boolean)false);
        if (instance == null) {
            return;
        }
        TestOnlyPhase currentPhase = instance.getCurrentTestOnlyPhase();
        if (currentPhase != null) {
            Matcher _matcher = ExpectationsUtil.convert(matcher);
            currentPhase.addArgMatcher(_matcher);
        }
    }

    public static Matcher convert(final ext.jtester.hamcrest.Matcher matcher) {
        return new BaseMatcher(){

            public boolean matches(Object item) {
                return matcher.matches(item);
            }

            public void describeTo(Description description) {
                StringDescription message = new StringDescription();
                matcher.describeTo(message);
                description.appendText((CharSequence)((Object)message).toString());
            }
        };
    }
}

