/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.spring;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jtester.annotations.AutoBeanInject;
import org.jtester.annotations.SpringInitMethod;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.exception.FindBeanImplClassException;
import org.jtester.utility.AnnotationUtils;
import org.jtester.utility.ArrayHelper;
import org.jtester.utility.JTesterLogger;
import org.jtester.utility.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementorFinder {
    public static Class findImplClazz(Class ownerClazz, String beanName, Class beanClazz, List<AutoBeanInject.BeanMap> beanMapping) throws FindBeanImplClassException {
        Class implClazz = beanClazz;
        if (ClazzHelper.isInterfaceOrAbstract(beanClazz)) {
            try {
                implClazz = ImplementorFinder.getImplClass(beanClazz, beanMapping);
            }
            catch (FindBeanImplClassException e) {
                String message = String.format("Look for spring bean for property[%s] of class[%s] error!", beanName, ownerClazz.getName());
                JTesterLogger.warn(message);
                throw new FindBeanImplClassException(message, e);
            }
        }
        if (implClazz == null || ClazzHelper.isInterfaceOrAbstract(implClazz)) {
            return null;
        }
        try {
            Constructor c = implClazz.getDeclaredConstructor(new Class[0]);
            if (c == null) {
                return null;
            }
            return implClazz;
        }
        catch (Throwable e) {
            String error = String.format("find default constructor function of class[%s] error.", implClazz.getName());
            throw new FindBeanImplClassException(error, e);
        }
    }

    public static String findInitMethodName(Class claz) {
        Set<Method> methods = AnnotationUtils.getMethodsAnnotatedWith(claz, SpringInitMethod.class);
        if (methods == null || methods.size() == 0) {
            return null;
        }
        Method method = methods.iterator().next();
        return method.getName();
    }

    protected static Class getImplClass(Class beanClazz, List<AutoBeanInject.BeanMap> beanMapping) throws FindBeanImplClassException {
        String beanClazzName = beanClazz.getName();
        Class<?> beanImplClazz = null;
        ArrayList<String> exceptions = new ArrayList<String>();
        for (AutoBeanInject.BeanMap beanMap : beanMapping) {
            String message;
            String intf = beanMap.intf();
            String impl = beanMap.impl();
            String beanImplClazzName = null;
            try {
                String regex;
                if (intf.equals(beanClazzName)) {
                    beanImplClazz = Class.forName(impl);
                }
                if (!intf.contains("*") || !beanClazzName.matches(regex = ClazzHelper.getPackageRegex(intf)) || StringHelper.equals(beanImplClazzName = ImplementorFinder.replace(intf, impl, beanClazzName), beanClazzName)) continue;
                beanImplClazz = ImplementorFinder.class.getClassLoader().loadClass(beanImplClazzName);
            }
            catch (ClassNotFoundException e) {
                message = String.format("\nCan't find implement class[%s] of interface[%s], use @BeanMap(intf=\"%s\",impl=\"%s\")", beanImplClazzName, beanClazzName, intf, impl);
                exceptions.add(message);
            }
            catch (NoClassDefFoundError err) {
                message = String.format("\nCan't find implement class[%s] of interface[%s], use @BeanMap(intf=\"%s\",impl=\"%s\")", beanImplClazzName, beanClazzName, intf, impl);
                exceptions.add(message);
            }
        }
        if (beanImplClazz == null) {
            if (exceptions.size() == 0) {
                throw new FindBeanImplClassException("can't find rule to find implement class for " + beanClazzName);
            }
            throw new FindBeanImplClassException(ArrayHelper.toString(exceptions.toArray(new String[0])));
        }
        return beanImplClazz;
    }

    protected static String replace(String interfaceKey, String implementKey, String interfaceClass) {
        String[] implSplits;
        String[] intfSplits = ImplementorFinder.splitBy(interfaceKey, "\\*\\*");
        if (intfSplits.length != (implSplits = ImplementorFinder.splitBy(implementKey, "\\*\\*")).length) {
            throw new RuntimeException(String.format("interface class expression[%s] and implement class expression[%s] aren't matched!", interfaceKey, implementKey));
        }
        String[] intfPacks = ImplementorFinder.splitIntfClazzByExpression(interfaceClass, intfSplits);
        int length = intfSplits.length;
        StringBuffer implementClass = new StringBuffer();
        for (int index = 0; index < length; ++index) {
            String intfSplit = intfSplits[index];
            String implSplit = implSplits[index];
            String realPack = ImplementorFinder.replaceAsterisk(intfSplit, implSplit, intfPacks[index * 2]);
            implementClass.append(realPack);
            if (index >= length - 1) continue;
            String doubleAsterisk = intfPacks[index * 2 + 1];
            implementClass.append(doubleAsterisk);
        }
        return implementClass.toString();
    }

    protected static String[] splitIntfClazzByExpression(String intfClazz, String[] exps) {
        StringBuffer regex = new StringBuffer();
        boolean firstExp = true;
        for (String exp : exps) {
            if (!firstExp) {
                regex.append("(.*)");
            } else {
                firstExp = false;
            }
            regex.append("(" + exp.replace(".", "\\.").replace("*", "[^\\.]*") + ")");
        }
        Pattern p = Pattern.compile(regex.toString());
        Matcher m = p.matcher(intfClazz);
        if (!m.matches()) {
            throw new RuntimeException(String.format("interface class expression[%s] and implement class expression[%s] aren't matched!", intfClazz, ArrayHelper.toString(exps)));
        }
        int count = m.groupCount();
        if (count != exps.length * 2 - 1) {
            throw new RuntimeException(String.format("can't find enough parts of interface class expression[%s] by expression[%s]!", intfClazz, ArrayHelper.toString(exps)));
        }
        String[] packs = new String[count];
        for (int index = 0; index < count; ++index) {
            packs[index] = m.group(index + 1);
        }
        return packs;
    }

    protected static String replaceAsterisk(String intf, String impl, String intfPack) {
        String[] implItems;
        String[] intfItems = ImplementorFinder.splitBy(intf, "\\*");
        if (intfItems.length != (implItems = ImplementorFinder.splitBy(impl, "\\*")).length) {
            throw new RuntimeException(String.format("item [%s] not match [%s]!", intf, impl));
        }
        String[] words = ImplementorFinder.splitIntfClazzByExpression(intfPack, intfItems);
        int length = intfItems.length;
        StringBuffer implPack = new StringBuffer();
        for (int index = 0; index < length; ++index) {
            implPack.append(implItems[index]);
            if (index >= length - 1) continue;
            String asterisk = words[index * 2 + 1];
            implPack.append(asterisk);
        }
        return implPack.toString();
    }

    private static String[] splitBy(String input, String regex) {
        String _temp = " " + input + " ";
        String[] splits = _temp.split(regex);
        for (int index = 0; index < splits.length; ++index) {
            splits[index] = splits[index].trim();
        }
        return splits;
    }
}

