/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.spring;

import javax.sql.DataSource;
import org.jtester.module.core.helper.ConfigurationHelper;
import org.jtester.module.database.environment.DBEnvironmentFactory;
import org.jtester.module.tracer.TracerBeanManager;
import org.jtester.utility.JTesterLogger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class JTesterBeanFactory
extends DefaultListableBeanFactory {
    private boolean ignoreNoSuchBean;

    public JTesterBeanFactory(BeanFactory parentBeanFactory, boolean ignoreNoSuchBean) {
        super(parentBeanFactory);
        this.ignoreNoSuchBean = ignoreNoSuchBean;
    }

    public Object getBean(String name, Class requiredType, Object[] args) throws BeansException {
        try {
            Object bean = this.getMyBean(name, requiredType, args);
            return bean;
        }
        catch (NoSuchBeanDefinitionException e) {
            if (this.ignoreNoSuchBean) {
                JTesterLogger.info("Ignore NoSuchBeanDefinitionException:" + e.getMessage());
                return null;
            }
            throw e;
        }
    }

    private Object getMyBean(String name, Class requiredType, Object[] args) throws BeansException {
        if (ConfigurationHelper.isSpringDataSourceName(name)) {
            DataSource dataSource = DBEnvironmentFactory.getDBEnvironment().getDataSource(false);
            return dataSource;
        }
        Object bean = super.getBean(name, requiredType, args);
        return bean;
    }

    public Object applyBeanPostProcessorsBeforeInitialization(Object existingBean, String beanName) {
        TracerBeanManager.registerBean(existingBean, beanName);
        return super.applyBeanPostProcessorsBeforeInitialization(existingBean, beanName);
    }
}

