/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.spring;

import org.jtester.annotations.Tracer;
import org.jtester.core.TestedObject;
import org.jtester.module.core.helper.SpringModuleHelper;
import org.jtester.module.core.helper.TracerModuleHelper;
import org.jtester.module.spring.JTesterBeanFactory;
import org.jtester.module.spring.SpringBeanFromFactory;
import org.jtester.module.spring.strategy.register.RegisterDynamicBean;
import org.jtester.utility.AnnotationUtils;
import org.jtester.utility.JTesterLogger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class JTesterSpringContext
extends ClassPathXmlApplicationContext {
    private final boolean ignoreNoSuchBean;

    public JTesterSpringContext(String[] configLocations, boolean refresh, ApplicationContext parent, boolean ignoreNoSuchBean) throws BeansException {
        super(configLocations, false, parent);
        this.ignoreNoSuchBean = ignoreNoSuchBean;
        if (refresh) {
            this.refresh();
        }
    }

    public JTesterSpringContext(Object testedObject, String[] configLocations, boolean ignoreNoSuchBean) throws BeansException {
        super(configLocations, false, null);
        this.ignoreNoSuchBean = ignoreNoSuchBean;
    }

    public final JTesterBeanFactory getJTesterBeanFactory() {
        ConfigurableListableBeanFactory beanFactory = super.getBeanFactory();
        return (JTesterBeanFactory)beanFactory;
    }

    protected ConfigurableListableBeanFactory obtainFreshBeanFactory() {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)super.obtainFreshBeanFactory();
        Class testedClazz = TestedObject.currTestedClazz();
        SpringBeanFromFactory.registerSpringBeanFromField(beanFactory, testedClazz);
        JTesterLogger.info("Refresh spring classpath application context, tested class:" + testedClazz.getName());
        RegisterDynamicBean.dynamicRegisterBeanDefinition(beanFactory, testedClazz);
        boolean traceSpringBean = TracerModuleHelper.traceSpringBean();
        Tracer tracer = AnnotationUtils.getClassLevelAnnotation(Tracer.class, testedClazz);
        if (tracer == null && traceSpringBean || tracer != null && tracer.spring()) {
            SpringModuleHelper.addTracerBeanDefinition((BeanDefinitionRegistry)beanFactory);
        }
        return beanFactory;
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        BeanFactory parent = this.getInternalParentBeanFactory();
        return new JTesterBeanFactory(parent, this.ignoreNoSuchBean);
    }
}

