/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.spring;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jtester.annotations.SpringBeanFrom;
import org.jtester.bytecode.imposteriser.JTesterProxy;
import org.jtester.bytecode.reflector.helper.FieldHelper;
import org.jtester.core.TestedObject;
import org.jtester.module.spring.JTesterBeanFactory;
import org.jtester.utility.AnnotationUtils;
import org.jtester.utility.JTesterLogger;
import org.jtester.utility.StringHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class SpringBeanFromFactory
implements FactoryBean,
BeanFactoryAware {
    public String fieldName;
    private JTesterBeanFactory beanFactory;
    private Class type = null;

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Object getObject() throws Exception {
        Class testClazz = TestedObject.currTestedClazz();
        Object o = JTesterProxy.proxy(testClazz, this.fieldName);
        return o;
    }

    public Class getObjectType() {
        if (this.type == null && this.beanFactory != null) {
            Class testClazz = TestedObject.currTestedClazz();
            Field field = FieldHelper.getField(testClazz, this.fieldName);
            this.type = field.getType();
        }
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (JTesterBeanFactory)beanFactory;
    }

    public static void registerSpringBeanFromField(DefaultListableBeanFactory beanFactory, Class testedClazz) {
        Set<Field> beanFields = AnnotationUtils.getFieldsAnnotatedWith(testedClazz, SpringBeanFrom.class);
        for (Field beanField : beanFields) {
            SpringBeanFrom beanFor = beanField.getAnnotation(SpringBeanFrom.class);
            String fieldName = beanField.getName();
            String beanName = beanFor.value();
            if (StringHelper.isBlankOrNull(beanName)) {
                beanName = fieldName;
            }
            SpringBeanFromFactory.registerProxyBeanDefinition(beanFactory, beanName, fieldName);
        }
    }

    private static void registerProxyBeanDefinition(DefaultListableBeanFactory beanFactory, String beanName, final String fieldName) {
        if (beanFactory.containsBeanDefinition(beanName)) {
            JTesterLogger.info(String.format("SpringBeanFrom BeanName[%s] has been defined in application context, so override bean definition.", beanName));
        }
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClassName(SpringBeanFromFactory.class.getName());
        beanDefinition.setScope("singleton");
        beanDefinition.setAutowireCandidate(true);
        beanDefinition.setLazyInit(true);
        beanDefinition.setAutowireMode(1);
        MutablePropertyValues properties = new MutablePropertyValues((Map)new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("fieldName", fieldName);
            }
        });
        beanDefinition.setPropertyValues(properties);
        beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }
}

