/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.spring.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jtester.module.spring.ibatis.SqlMapClientBuilderEx;
import org.springframework.core.io.Resource;
import org.springframework.orm.ibatis.SqlMapClientFactoryBean;
import org.springframework.util.ClassUtils;

public class SqlMapClientFactoryBeanEx
extends SqlMapClientFactoryBean {
    private static final boolean buildSqlMapClientWithInputStreamMethodAvailable = ClassUtils.hasMethod(SqlMapClientBuilderEx.class, (String)"buildSqlMapClient", (Class[])new Class[]{InputStream.class});
    private static final boolean buildSqlMapClientWithInputStreamAndPropertiesMethodAvailable = ClassUtils.hasMethod(SqlMapClientBuilderEx.class, (String)"buildSqlMapClient", (Class[])new Class[]{InputStream.class, Properties.class});
    private static final Map<String, SqlMapClient> sqlMapClients = new HashMap<String, SqlMapClient>();

    protected SqlMapClient buildSqlMapClient(Resource configLocation, Properties properties) throws IOException {
        String configURI = configLocation.getURI().toString();
        SqlMapClient client = sqlMapClients.get(configURI);
        if (client == null) {
            InputStream is = configLocation.getInputStream();
            client = this.buildSqlMapClient(is, properties);
            sqlMapClients.put(configURI, client);
        }
        return client;
    }

    private SqlMapClient buildSqlMapClient(InputStream is, Properties properties) {
        if (properties != null) {
            if (buildSqlMapClientWithInputStreamAndPropertiesMethodAvailable) {
                return SqlMapClientBuilderEx.buildSqlMapClientByJTester(is, properties);
            }
            return SqlMapClientBuilderEx.buildSqlMapClient((Reader)new InputStreamReader(is), (Properties)properties);
        }
        if (buildSqlMapClientWithInputStreamMethodAvailable) {
            return SqlMapClientBuilderEx.buildSqlMapClient((InputStream)is);
        }
        return SqlMapClientBuilderEx.buildSqlMapClient((Reader)new InputStreamReader(is));
    }
}

