/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.spring.ibatis;

import com.ibatis.common.resources.Resources;
import com.ibatis.common.xml.Nodelet;
import com.ibatis.common.xml.NodeletUtils;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapConfigParser;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapParser;
import com.ibatis.sqlmap.engine.builder.xml.XmlParserState;
import java.io.InputStream;
import java.util.Properties;
import org.jtester.bytecode.reflector.FieldAccessor;
import org.jtester.module.core.helper.ConfigurationHelper;
import org.jtester.utility.JTesterLogger;
import org.w3c.dom.Node;

public class SqlMapConfigParserEx
extends SqlMapConfigParser {
    private static final FieldAccessor stateField = new FieldAccessor(SqlMapConfigParser.class, "state");
    private XmlParserState state = new XmlParserState();

    protected void addSqlMapNodelets() {
        this.state = (XmlParserState)stateField.get((Object)this);
        this.parser.addNodelet("/sqlMapConfig/sqlMap", (Nodelet)new JTesterIbatisNodelet(this.state));
    }

    private static class JTesterIbatisNodelet
    implements Nodelet {
        private XmlParserState state = new XmlParserState();

        protected JTesterIbatisNodelet(XmlParserState state) {
            this.state = state;
        }

        public void process(Node node) {
            String resource = null;
            try {
                this.state.getConfig().getErrorContext().setActivity("loading the SQL Map resource");
                Properties attributes = NodeletUtils.parseAttributes((Node)node, (Properties)this.state.getGlobalProps());
                resource = attributes.getProperty("resource");
                String url = attributes.getProperty("wikiUrl");
                InputStream inputStream = null;
                if (resource != null) {
                    this.state.getConfig().getErrorContext().setResource(resource);
                    inputStream = Resources.getResourceAsStream((String)resource);
                } else if (url != null) {
                    this.state.getConfig().getErrorContext().setResource(url);
                    inputStream = Resources.getUrlAsStream((String)url);
                } else {
                    throw new SqlMapException("The <sqlMap> element requires either a resource or a url attribute.");
                }
                new SqlMapParser(this.state).parse(inputStream);
            }
            catch (Throwable e) {
                String error = String.format("loading sql map resource[%s] error:%s.", resource, e.getMessage());
                boolean throwException = ConfigurationHelper.getBoolean("ibatis.sqlmap.throw.exception");
                if (throwException) {
                    throw new RuntimeException(error, e);
                }
                JTesterLogger.warn(error);
            }
        }
    }
}

