/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.spring.strategy.cleaner;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Set;
import org.jtester.annotations.SpringBeanByName;
import org.jtester.annotations.SpringBeanByType;
import org.jtester.bytecode.reflector.helper.FieldHelper;
import org.jtester.exception.JTesterException;
import org.jtester.utility.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanCleaner {
    public static void cleanSpringBeans(Object testedObject) {
        if (testedObject != null) {
            SpringBeanCleaner.cleanSpringBeansByAnnotation(testedObject, SpringBeanByName.class);
            SpringBeanCleaner.cleanSpringBeansByAnnotation(testedObject, SpringBeanByType.class);
        }
    }

    private static void cleanSpringBeansByAnnotation(Object testedObject, Class<? extends Annotation> annotation) {
        Class<?> testedClazz = testedObject.getClass();
        Set<Field> fields = AnnotationUtils.getFieldsAnnotatedWith(testedClazz, annotation);
        for (Field field : fields) {
            try {
                FieldHelper.setFieldValue(testedObject, field, null);
            }
            catch (Throwable e) {
                String error = String.format("clean @%s field[%s] in class[%s] error.", annotation.getName(), field.getName(), testedClazz.getName());
                throw new JTesterException(error, e);
            }
        }
    }
}

