/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.spring.strategy.injector;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Set;
import org.jtester.annotations.SpringBeanByName;
import org.jtester.bytecode.reflector.helper.FieldHelper;
import org.jtester.exception.JTesterException;
import org.jtester.module.spring.JTesterBeanFactory;
import org.jtester.module.spring.strategy.injector.SpringBeanInjector;
import org.jtester.utility.AnnotationUtils;
import org.jtester.utility.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SpringBeanInjectorByName
extends SpringBeanInjector {
    SpringBeanInjectorByName() {
    }

    @Override
    public void injectBy(JTesterBeanFactory beanFactory, Object testedObject, Class<? extends Annotation> annotation) {
        Class<?> testedClazz = testedObject.getClass();
        Set<Field> fields = AnnotationUtils.getFieldsAnnotatedWith(testedClazz, SpringBeanByName.class);
        for (Field field : fields) {
            try {
                SpringBeanByName byName = field.getAnnotation(SpringBeanByName.class);
                String beanName = byName.value();
                if (StringHelper.isBlankOrNull(byName.value())) {
                    beanName = field.getName();
                }
                Object bean = beanFactory.getBean(beanName);
                FieldHelper.setFieldValue(testedObject, field, bean);
            }
            catch (Throwable e) {
                String error = String.format("inject @SpringBeanByName field[%s] in class[%s] error.", field.getName(), testedClazz.getName());
                throw new JTesterException(error, e);
            }
        }
    }
}

