/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.spring.strategy.injector;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import org.jtester.annotations.SpringBeanByType;
import org.jtester.bytecode.reflector.helper.FieldHelper;
import org.jtester.exception.JTesterException;
import org.jtester.module.spring.JTesterBeanFactory;
import org.jtester.module.spring.strategy.injector.SpringBeanInjector;
import org.jtester.utility.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SpringBeanInjectorByType
extends SpringBeanInjector {
    SpringBeanInjectorByType() {
    }

    @Override
    public void injectBy(JTesterBeanFactory beanFactory, Object testedObject, Class<? extends Annotation> annotation) {
        Class<?> testedClazz = testedObject.getClass();
        Set<Field> fields = AnnotationUtils.getFieldsAnnotatedWith(testedClazz, SpringBeanByType.class);
        for (Field field : fields) {
            try {
                Object bean = this.getSpringBeanByType(beanFactory, field.getType());
                FieldHelper.setFieldValue(testedObject, field, bean);
            }
            catch (Throwable e) {
                String error = String.format("inject @SpringBeanByType field[%s] in class[%s] error.", field.getName(), testedClazz.getName());
                throw new JTesterException(error, e);
            }
        }
    }

    private Object getSpringBeanByType(JTesterBeanFactory beanFactory, Class type) {
        Map beans = beanFactory.getBeansOfType(type);
        if (beans == null || beans.size() == 0) {
            throw new JTesterException("Unable to get Spring bean by type. No Spring bean found for type " + type.getSimpleName());
        }
        if (beans.size() > 1) {
            throw new JTesterException("Unable to get Spring bean by type. More than one possible Spring bean for type " + type.getSimpleName() + ". Possible beans; " + beans);
        }
        return beans.values().iterator().next();
    }
}

