/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.spring.strategy.register;

import java.util.Queue;
import org.jtester.annotations.Property;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.module.spring.strategy.register.RegisterBeanDefinition;
import org.jtester.module.spring.strategy.register.RegisterDynamicBean;
import org.jtester.utility.StringHelper;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BeanMeta {
    String initMethod;
    String beanName;
    Class beanClaz;
    Property[] properties;
    private final Queue<Class> queue;
    private final RegisterBeanDefinition definitions;

    public BeanMeta(Queue<Class> queue, RegisterBeanDefinition definitions) {
        this.queue = queue;
        this.definitions = definitions;
    }

    boolean isConcreteClazz() {
        if (this.beanClaz.isAnnotation()) {
            return false;
        }
        if (this.beanClaz.isEnum()) {
            return false;
        }
        return !ClazzHelper.isInterfaceOrAbstract(this.beanClaz);
    }

    void registerBeanDefinition() {
        RootBeanDefinition beanDefinition = RegisterDynamicBean.getRootBeanDefinition(this.beanName, this.beanClaz, this.initMethod, false);
        for (Property property : this.properties) {
            this.checkPropertyDefine(property);
            if (StringHelper.isBlankOrNull(property.value())) {
                this.registerRefBean(property.ref(), property.clazz());
                RuntimeBeanReference reference = new RuntimeBeanReference(property.ref());
                PropertyValue pv = new PropertyValue(property.name(), (Object)reference);
                beanDefinition.getPropertyValues().addPropertyValue(pv);
                continue;
            }
            PropertyValue pv = new PropertyValue(property.name(), (Object)property.value());
            beanDefinition.getPropertyValues().addPropertyValue(pv);
        }
        this.definitions.register(this.beanName, (AbstractBeanDefinition)beanDefinition);
        this.queue.offer(this.beanClaz);
    }

    private void registerRefBean(String refname, Class clazz) {
        if (clazz == Property.class) {
            return;
        }
        if (ClazzHelper.isInterfaceOrAbstract(clazz)) {
            throw new RuntimeException("the reference bean[" + refname + "] class should be an instancable class, but actual is " + clazz.getName() + ".");
        }
        RootBeanDefinition beanDefinition = RegisterDynamicBean.getRootBeanDefinition(refname, clazz, null, true);
        this.definitions.register(refname, (AbstractBeanDefinition)beanDefinition);
        this.queue.add(clazz);
    }

    private void checkPropertyDefine(Property property) {
        if (StringHelper.isBlankOrNull(property.name())) {
            throw new RuntimeException("the value of @BeanProperty name() can't be empty.");
        }
        if (StringHelper.isBlankOrNull(property.value()) && StringHelper.isBlankOrNull(property.ref())) {
            throw new RuntimeException("the values of @BeanProperty value() and ref() can't be all empty.");
        }
    }
}

