/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.spring.strategy.register;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jtester.annotations.AutoBeanInject;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.exception.FindBeanImplClassException;
import org.jtester.module.spring.ImplementorFinder;
import org.jtester.utility.JTesterLogger;
import org.jtester.utility.StringHelper;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterBeanDefinition {
    private final DefaultListableBeanFactory factory;
    private final AutoBeanInject autoBeanInject;
    private final List<AutoBeanInject.BeanMap> mappingRules;
    private boolean allowAutoInject;
    private static final String VALID_PACK_REGEX = "[\\w_$\\.\\*]+";
    private static Set<String> DEFAULT_EXCLUDE_PROPERTIES = new HashSet<String>(){
        private static final long serialVersionUID = 705657590280935844L;
        {
            this.add("class");
            this.add("override");
        }
    };
    private static Set<String> DEFAULT_EXCLUDE_PACKAGES = new HashSet<String>(){
        private static final long serialVersionUID = -102059987060939894L;
        {
            this.add("org.springframework.");
            this.add("java.");
            this.add("javax.");
            this.add("org.spring.");
        }
    };

    public RegisterBeanDefinition(DefaultListableBeanFactory factory, AutoBeanInject autoBeanInject) {
        this.factory = factory;
        this.autoBeanInject = autoBeanInject;
        if (autoBeanInject == null || !autoBeanInject.value()) {
            this.allowAutoInject = false;
            this.mappingRules = new ArrayList<AutoBeanInject.BeanMap>();
        } else {
            this.allowAutoInject = true;
            this.mappingRules = RegisterBeanDefinition.checkBeanMap(this.autoBeanInject.maps());
        }
    }

    private static List<AutoBeanInject.BeanMap> checkBeanMap(AutoBeanInject.BeanMap[] autoMaps) {
        ArrayList<AutoBeanInject.BeanMap> mapping = new ArrayList<AutoBeanInject.BeanMap>();
        if (autoMaps == null || autoMaps.length == 0) {
            return mapping;
        }
        for (AutoBeanInject.BeanMap autoMap : autoMaps) {
            String intf = autoMap.intf();
            String impl = autoMap.impl();
            if (StringHelper.isBlankOrNull(intf) || StringHelper.isBlankOrNull(impl)) {
                throw new RuntimeException(String.format("Illegal value @AutoMap(intf=\"%s\",impl=\"%s\") value", intf, impl));
            }
            if (!intf.matches(VALID_PACK_REGEX) || !impl.matches(VALID_PACK_REGEX)) {
                throw new RuntimeException(String.format("Illegal value @AutoMap(intf=\"%s\",impl=\"%s\") value", intf, impl));
            }
            mapping.add(autoMap);
        }
        return mapping;
    }

    public boolean doesHaveRegisted(String beanName) {
        boolean doesRegisted = this.factory.containsBeanDefinition(beanName);
        return doesRegisted;
    }

    public Class findImplementClass(Class ownerClazz, String propName, Class propClazz) throws FindBeanImplClassException {
        Class implClazz = ImplementorFinder.findImplClazz(ownerClazz, propName, propClazz, this.mappingRules);
        return implClazz;
    }

    public void register(String beanName, AbstractBeanDefinition beanDefinition) {
        this.factory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    public void ignoreNotFoundException(Throwable e) {
        if (this.autoBeanInject != null && !this.autoBeanInject.ignoreNotFound()) {
            throw new RuntimeException(e);
        }
        JTesterLogger.warn("ignore NotFound:" + (e == null ? "<null>" : e.getMessage()));
    }

    public boolean allowAutoInject() {
        return this.allowAutoInject;
    }

    public boolean allowAutoInject(String beanName) {
        if (!this.allowAutoInject) {
            return false;
        }
        boolean registed = this.doesHaveRegisted(beanName);
        return !registed;
    }

    public boolean isExcludeProperty(String name, Class clazz) {
        if (clazz.isEnum() || clazz.isAnnotation() || clazz.isArray() || clazz.isPrimitive()) {
            return true;
        }
        boolean isExcludeProperty = this.isExcludeProperty(name);
        if (isExcludeProperty) {
            return true;
        }
        boolean isExcludeClazz = this.isExcludePackage(clazz.getName());
        return isExcludeClazz;
    }

    private boolean isExcludeProperty(String property) {
        if (StringHelper.isBlankOrNull(property)) {
            return true;
        }
        if (DEFAULT_EXCLUDE_PROPERTIES.contains(property) || this.factory.containsBeanDefinition(property)) {
            return true;
        }
        String[] excludeProperties = this.autoBeanInject.excludeProperties();
        if (excludeProperties == null || excludeProperties.length == 0) {
            return false;
        }
        for (String excludeProperty : excludeProperties) {
            if (!property.equals(excludeProperty)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcludePackage(String clazzname) {
        for (String excludePackage : DEFAULT_EXCLUDE_PACKAGES) {
            if (!clazzname.startsWith(excludePackage)) continue;
            return true;
        }
        String[] excludePackages = this.autoBeanInject.excludePackages();
        if (excludePackages == null || excludePackages.length == 0) {
            return false;
        }
        for (String excludePackage : excludePackages) {
            String regex = ClazzHelper.getPackageRegex(excludePackage);
            if (!clazzname.matches(regex)) continue;
            return true;
        }
        return false;
    }
}

