/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.spring.strategy.register;

import java.util.LinkedList;
import java.util.Queue;
import org.jtester.annotations.AutoBeanInject;
import org.jtester.exception.FindBeanImplClassException;
import org.jtester.module.spring.ImplementorFinder;
import org.jtester.module.spring.strategy.register.RegisterBeanDefinition;
import org.jtester.module.spring.strategy.register.SpringBeanByNameRegister;
import org.jtester.module.spring.strategy.register.SpringBeanByTypeRegister;
import org.jtester.module.spring.strategy.register.SpringBeanRegister;
import org.jtester.module.spring.strategy.register.types.PropertiesRegister;
import org.jtester.utility.AnnotationUtils;
import org.jtester.utility.StringHelper;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class RegisterDynamicBean {
    Queue<Class> beanFields = new LinkedList<Class>();
    private final DefaultListableBeanFactory beanFactory;
    private final Class testedClazz;
    private final RegisterBeanDefinition definitionRegister;
    static final SpringBeanRegister byNameRegister = new SpringBeanByNameRegister();
    static final SpringBeanRegister byTypeRegister = new SpringBeanByTypeRegister();

    public static void dynamicRegisterBeanDefinition(DefaultListableBeanFactory beanFactory, Class testedClazz) {
        RegisterDynamicBean dynamicBean = new RegisterDynamicBean(beanFactory, testedClazz);
        try {
            dynamicBean.registerSpringBean();
        }
        catch (FindBeanImplClassException e) {
            throw new RuntimeException(e);
        }
    }

    RegisterDynamicBean(DefaultListableBeanFactory beanFactory, Class testedClazz) {
        if (testedClazz == null) {
            throw new RuntimeException("Current thread hasn't registered tested class!");
        }
        this.beanFactory = beanFactory;
        this.testedClazz = testedClazz;
        AutoBeanInject autoBeanInject = AnnotationUtils.getClassLevelAnnotation(AutoBeanInject.class, testedClazz);
        this.definitionRegister = new RegisterBeanDefinition(this.beanFactory, autoBeanInject);
    }

    protected final void registerSpringBean() throws FindBeanImplClassException {
        byNameRegister.register(this.testedClazz, this.beanFields, this.definitionRegister);
        byTypeRegister.register(this.testedClazz, this.beanFields, this.definitionRegister);
        if (!this.definitionRegister.allowAutoInject()) {
            return;
        }
        Class clazz = this.beanFields.poll();
        while (clazz != null) {
            if (clazz != null) {
                PropertiesRegister.registerPropertiesBean(clazz, this.definitionRegister, this.beanFields);
            }
            clazz = this.beanFields.poll();
        }
    }

    public static RootBeanDefinition getRootBeanDefinition(String beanName, Class implClazz, String initMethod, boolean isLazy) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClassName(implClazz.getName());
        beanDefinition.setScope("singleton");
        beanDefinition.setAutowireCandidate(true);
        beanDefinition.setLazyInit(isLazy);
        beanDefinition.setAutowireMode(1);
        String init_method = initMethod;
        if (StringHelper.isBlankOrNull(initMethod)) {
            init_method = ImplementorFinder.findInitMethodName(implClazz);
        }
        if (!StringHelper.isBlankOrNull(init_method)) {
            beanDefinition.setInitMethodName(init_method);
        }
        return beanDefinition;
    }
}

