/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.spring.strategy.register;

import java.lang.reflect.Field;
import java.util.Queue;
import java.util.Set;
import org.jtester.exception.FindBeanImplClassException;
import org.jtester.module.core.JMockitModule;
import org.jtester.module.core.helper.JMockitModuleHelper;
import org.jtester.module.core.helper.ModulesManager;
import org.jtester.module.spring.strategy.register.BeanMeta;
import org.jtester.module.spring.strategy.register.RegisterBeanDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpringBeanRegister {
    public void register(Class testedClazz, Queue<Class> queue, RegisterBeanDefinition definitions) throws FindBeanImplClassException {
        Set<Field> fields = this.getRegisterField(testedClazz);
        for (Field field : fields) {
            Class impl;
            if (ModulesManager.isModuleEnabled(JMockitModule.class)) {
                JMockitModuleHelper.doesSpringBeanFieldIllegal(field);
            }
            BeanMeta beanMeta = new BeanMeta(queue, definitions);
            this.initSpringBean(field, beanMeta);
            if (beanMeta.isConcreteClazz()) {
                beanMeta.registerBeanDefinition();
                continue;
            }
            if (!definitions.allowAutoInject(beanMeta.beanName) || (impl = definitions.findImplementClass(testedClazz, beanMeta.beanName, field.getType())) == null) continue;
            beanMeta.beanClaz = impl;
            beanMeta.registerBeanDefinition();
        }
    }

    protected abstract Set<Field> getRegisterField(Class var1);

    protected abstract void initSpringBean(Field var1, BeanMeta var2);
}

