/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.spring.strategy.register.types;

import java.util.Queue;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.exception.FindBeanImplClassException;
import org.jtester.module.spring.strategy.register.RegisterBeanDefinition;
import org.jtester.module.spring.strategy.register.RegisterDynamicBean;
import org.jtester.module.spring.strategy.register.types.AutowiredPropertiesRegister;
import org.jtester.module.spring.strategy.register.types.MethodPropertiesRegister;
import org.jtester.module.spring.strategy.register.types.ResourcePropertiesRegister;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertiesRegister {
    protected final Class ownerClazz;
    protected final RegisterBeanDefinition definitionRegister;

    protected PropertiesRegister(Class ownerClazz, RegisterBeanDefinition definitionRegister) {
        this.ownerClazz = ownerClazz;
        this.definitionRegister = definitionRegister;
    }

    public abstract void registerProperties(Queue<Class> var1);

    public static void registerPropertiesBean(Class ownerClazz, RegisterBeanDefinition definitionRegister, Queue<Class> registedBeanClazz) {
        boolean isAutowiredAvailable;
        new MethodPropertiesRegister(ownerClazz, definitionRegister).registerProperties(registedBeanClazz);
        boolean isResourceAvailable = ClazzHelper.isClassAvailable("javax.annotation.Resource");
        if (isResourceAvailable) {
            new ResourcePropertiesRegister(ownerClazz, definitionRegister).registerProperties(registedBeanClazz);
        }
        if (isAutowiredAvailable = ClazzHelper.isClassAvailable("org.springframework.beans.factory.annotation.Autowired")) {
            new AutowiredPropertiesRegister(ownerClazz, definitionRegister).registerProperties(registedBeanClazz);
        }
    }

    protected void registerBean(String beanName, Class propClazz, Queue<Class> registedBeanClazz) {
        try {
            boolean doesRegisted = this.definitionRegister.doesHaveRegisted(beanName);
            if (doesRegisted) {
                return;
            }
            Class impl = this.definitionRegister.findImplementClass(this.ownerClazz, beanName, propClazz);
            if (impl == null) {
                return;
            }
            RootBeanDefinition beanDefinition = RegisterDynamicBean.getRootBeanDefinition(beanName, impl, null, true);
            this.definitionRegister.register(beanName, (AbstractBeanDefinition)beanDefinition);
            registedBeanClazz.offer(impl);
        }
        catch (FindBeanImplClassException e) {
            this.definitionRegister.ignoreNotFoundException(e);
        }
    }
}

