/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.tracer;

import java.util.HashMap;
import java.util.Map;
import org.jtester.utility.StringHelper;

public class TracerBeanManager {
    private static Map<Class, String> beanNameMap = new HashMap<Class, String>();

    public static void registerBean(Object bean, String beanName) {
        if (bean == null) {
            return;
        }
        beanNameMap.put(bean.getClass(), beanName);
    }

    public static String getBeanName(Class clazz) {
        if (clazz == null) {
            return "<null>";
        }
        String beanName = beanNameMap.get(clazz);
        if (beanName == null) {
            return clazz.getSimpleName();
        }
        return beanName;
    }

    public static void clear() {
        beanNameMap.clear();
    }

    public static String getSourceBeanName(Class source) {
        String beanName = TracerBeanManager.getBeanName(source);
        return StringHelper.isBlankOrNull(beanName) ? "test-class" : beanName;
    }

    public static String getTargetBeanName(Class target) {
        return TracerBeanManager.getBeanName(target);
    }
}

