/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.tracer;

import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Method;
import org.jtester.annotations.Tracer;
import org.jtester.module.core.helper.TracerModuleHelper;
import org.jtester.module.tracer.jdbc.JdbcTracerManager;
import org.jtester.module.tracer.spring.BeanTracerManager;
import org.jtester.module.tracer.spring.MethodTracerEvent;
import org.jtester.utility.ResourceHelper;
import org.jtester.utility.StringHelper;

public class TracerManager {
    static ThreadLocal<File> tracerFile = new ThreadLocal();

    public static void startTracer(Tracer tracer, Class testedClazz, Method testMethod) {
        boolean traceBean = false;
        boolean traceJdbc = false;
        if (tracer != null) {
            traceBean = tracer.spring();
            traceJdbc = tracer.jdbc();
        } else {
            traceBean = TracerModuleHelper.traceSpringBean();
            traceJdbc = TracerModuleHelper.traceJDBC();
        }
        if (traceBean) {
            BeanTracerManager.initMonitorBeans(traceBean, testedClazz, tracer);
        }
        if (traceJdbc) {
            JdbcTracerManager.initJdbcTracer(traceJdbc);
        }
        File htmlFile = TracerManager.getAboutMethodFile(testedClazz, testMethod, ".html");
        tracerFile.set(null);
        if (traceBean || traceJdbc) {
            tracerFile.set(htmlFile);
            TracerManager.writeTraceHtmlFile(htmlFile);
        } else {
            tracerFile.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeTraceHtmlFile(File htmlFile) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(htmlFile, false);
            writer.append("<html><head>");
            writer.append(String.format("<META HTTP-EQUIV='Content-Type' CONTENT='text/html; charset=%s'>", ResourceHelper.defaultFileEncoding()));
            writer.append("<style>");
            String css = ResourceHelper.readFromFile("org/jtester/testng/UserTestReporter.css");
            writer.append(css);
            writer.append("</style></head>");
            writer.append("<table>");
        }
        catch (Exception e) {
            TracerManager.stopExceptionThrow(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable e) {
                    TracerManager.stopExceptionThrow(e);
                }
            }
        }
    }

    public static void addBeanTracerEvent(MethodTracerEvent event) {
        if (event == null) {
            return;
        }
        String info = event.toHtmlString();
        TracerManager.appendHtmlFile(info);
        BeanTracerManager.addTracer(event);
    }

    public static void addBeanTracerResult(MethodTracerEvent event, Object result) {
        if (event == null) {
            return;
        }
        String info = BeanTracerManager.toTracerString(result);
        String html = MethodTracerEvent.getResultHtml(event.getSourceClazz(), event.getTargetClazz(), event.getMethodName(), info);
        TracerManager.appendHtmlFile(html);
    }

    public static void addBeanTracerException(MethodTracerEvent event, Throwable e) {
        if (event == null) {
            return;
        }
        String info = "throw exception:\n" + StringHelper.exceptionTrace(e);
        String html = MethodTracerEvent.getResultHtml(event.getSourceClazz(), event.getTargetClazz(), event.getMethodName(), info);
        TracerManager.appendHtmlFile(html);
    }

    private static void appendHtmlFile(String html) {
        File htmlFile = tracerFile.get();
        boolean traceBean = BeanTracerManager.isTracerEnabled();
        if (htmlFile == null || !traceBean) {
            return;
        }
        try {
            FileWriter writer = new FileWriter(htmlFile, true);
            writer.append(html);
            writer.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void addJdbcTracerEvent(String sql) {
        boolean traceJdbc = JdbcTracerManager.isTracerEnabled();
        if (!traceJdbc) {
            return;
        }
        JdbcTracerManager.addSQLTracer(sql);
    }

    public static void endTracer(Class testClazz, String method) {
        File htmlFile = tracerFile.get();
        boolean traceBean = BeanTracerManager.isTracerEnabled();
        if (htmlFile == null || !traceBean) {
            return;
        }
        try {
            String sequenceDescription = BeanTracerManager.endMonitorBean();
            String sql = JdbcTracerManager.endTracer();
            TracerManager.writeSequenceChart(htmlFile, sequenceDescription, sql);
        }
        catch (Throwable e) {
            String message = String.format("test class:%s, test method:%s.", testClazz.getName(), method);
            RuntimeException newE = new RuntimeException(message, e);
            TracerManager.stopExceptionThrow(newE);
        }
    }

    private static void stopExceptionThrow(Throwable e) {
        if (e != null) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSequenceChart(File htmlFile, String sequenceDescription, String sql) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(htmlFile, true);
            writer.write("</table><br/>");
            if (!StringHelper.isBlankOrNull(sequenceDescription)) {
                writer.append("<br/><div>").append(sequenceDescription).append("</div><br/>");
            }
            if (!StringHelper.isBlankOrNull(sql)) {
                writer.write(sql);
            }
            writer.append("</html>");
        }
        catch (Exception e) {
            TracerManager.stopExceptionThrow(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable e) {
                    TracerManager.stopExceptionThrow(e);
                }
            }
        }
    }

    private static File getAboutMethodFile(Class testClazz, Method testMethod, String surfix) {
        String basedir = System.getProperty("user.dir") + "/target/tracer/";
        String clazzName = testClazz.getName();
        String methodName = testMethod.getName();
        String path = basedir + clazzName.replace('.', '/');
        File htmlFile = new File(path + "#" + methodName + surfix);
        ResourceHelper.mkFileParentDir(htmlFile);
        return htmlFile;
    }
}

