/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.tracer;

import java.util.HashSet;
import java.util.List;
import org.jtester.module.tracer.spring.MethodTracerEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracerSequece {
    public static String getSequenceDescription(List<MethodTracerEvent> tracers) {
        if (tracers == null) {
            return null;
        }
        StringBuffer prefix = new StringBuffer();
        StringBuffer surfix = new StringBuffer();
        HashSet<String> beans = new HashSet<String>();
        surfix.append("[c]\n");
        for (MethodTracerEvent tracer : tracers) {
            String source = tracer.getSourceBeanName();
            String target = tracer.getTargetBeanName();
            if (!beans.contains(source)) {
                prefix.append(String.format("%s: \"%s\"\n", TracerSequece.filterUnsupport(source), source));
                beans.add(source);
            }
            if (!beans.contains(target)) {
                prefix.append(String.format("%s: \"%s\"\n", TracerSequece.filterUnsupport(target), target));
                beans.add(target);
            }
            String method = tracer.getMethodName();
            surfix.append(String.format("%s:%s.%s\n", TracerSequece.filterUnsupport(source), TracerSequece.filterUnsupport(target), method));
        }
        surfix.append("[/c]");
        if (beans.size() < 2) {
            return null;
        }
        return prefix.toString() + "\n" + surfix.toString();
    }

    private static String filterUnsupport(String in) {
        return in.replaceAll("\\W", "_");
    }
}

