/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.tracer.jdbc;

import org.jtester.module.tracer.TracerBeanManager;
import org.jtester.module.tracer.jdbc.TracerSQLUtility;

public class JdbcTracerEvent {
    private Class beanClazz;
    private String sql;

    public JdbcTracerEvent(Class beanClazz, String sql) {
        this.beanClazz = beanClazz;
        this.sql = sql;
    }

    public Class getBeanClazz() {
        return this.beanClazz;
    }

    public String getSql() {
        return this.sql;
    }

    public String toHtmlString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<tr>");
        if (this.beanClazz == null) {
            buffer.append("<td>bean</td>");
        } else {
            String beanName = TracerBeanManager.getBeanName(this.beanClazz);
            buffer.append(String.format("<td title='%s'>%s</td>", this.beanClazz.getName(), beanName));
        }
        buffer.append("<td>");
        buffer.append(TracerSQLUtility.highlightSql(this.sql));
        buffer.append("</td>");
        buffer.append("</tr>");
        return buffer.toString();
    }
}

