/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.tracer.jdbc;

import java.util.LinkedList;
import java.util.Queue;
import org.jtester.module.tracer.jdbc.JdbcTracerEvent;
import org.jtester.module.tracer.spring.BeanTracerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcTracerManager {
    public static ThreadLocal<Queue<JdbcTracerEvent>> threadTracerEvents = new ThreadLocal();
    private static ThreadLocal<Boolean> isJdbcEnabled = new ThreadLocal();

    public static void initJdbcTracer(boolean isTracer) {
        Queue<JdbcTracerEvent> tracerEvents = threadTracerEvents.get();
        if (tracerEvents == null) {
            tracerEvents = new LinkedList<JdbcTracerEvent>();
            threadTracerEvents.set(tracerEvents);
        }
        tracerEvents.clear();
        isJdbcEnabled.set(isTracer);
    }

    public static boolean isTracerEnabled() {
        Boolean bl = isJdbcEnabled.get();
        return bl == null ? false : bl;
    }

    public static Queue<JdbcTracerEvent> disableJdbcTracer() {
        Queue<JdbcTracerEvent> tracerEvents = threadTracerEvents.get();
        threadTracerEvents.remove();
        isJdbcEnabled.set(false);
        return tracerEvents;
    }

    public static void addSQLTracer(String sql) {
        Queue<JdbcTracerEvent> tracerEvents = threadTracerEvents.get();
        boolean isTracer = isJdbcEnabled.get();
        if (tracerEvents == null || !isTracer) {
            return;
        }
        Class beanClazz = BeanTracerManager.getLastBeanClazz();
        JdbcTracerEvent tracerEvent = new JdbcTracerEvent(beanClazz, sql);
        tracerEvents.add(tracerEvent);
    }

    public static void continueThreadMonitorJdbc() {
        isJdbcEnabled.set(true);
    }

    public static void suspendThreadMonitorJdbc() {
        isJdbcEnabled.set(false);
    }

    public static String endTracer() {
        Queue<JdbcTracerEvent> tracerEvents = threadTracerEvents.get();
        boolean isTrace = isJdbcEnabled.get();
        if (tracerEvents == null || !isTrace) {
            return null;
        }
        StringBuffer buffer = new StringBuffer("<table>");
        buffer.append("<tr><td>spring-bean</td><td>SQL-Statement</td></tr>");
        for (JdbcTracerEvent tracer : tracerEvents) {
            buffer.append(tracer.toHtmlString());
        }
        buffer.append("</table>");
        tracerEvents.clear();
        threadTracerEvents.remove();
        return buffer.toString();
    }
}

