/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.tracer.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.jtester.module.tracer.TracerManager;

public class StatementProxy
implements InvocationHandler {
    private final Statement statement;
    private static final Set<String> SQL_EXECUTE_METHODS = new HashSet<String>(){
        private static final long serialVersionUID = 3331093299449024077L;
        {
            this.add("executeQuery");
            this.add("execute");
            this.add("executeUpdate");
        }
    };

    public StatementProxy(Statement statement) {
        this.statement = statement;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object sql;
        boolean hasArgs;
        Object result = method.invoke((Object)this.statement, args);
        String methodname = method.getName();
        boolean bl = hasArgs = args != null && args.length > 0;
        if (SQL_EXECUTE_METHODS.contains(methodname) && hasArgs && (sql = args[0]) instanceof String) {
            TracerManager.addJdbcTracerEvent((String)sql);
        }
        return result;
    }
}

